/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.config.Column;

/**
 *
 * @author gevirl
 */
// this cell maintains a unique integer count for use in building unique record id keys
public class UniqueIntegerCell extends IntegerCell {
    
    @Override
    public void stateChanged(ChangeEvent ce) {
        int row = this.getRow();
       
        // get all the notifier columns of this cell column
        List<Column> notifierColumns = this.getNotifiers();
        
        // get their values - quit if not all there
        ArrayList<String> notifierValues = new ArrayList<>();
        for (Column column : notifierColumns){
            CellBase notifierCell = (CellBase)this.model.getValueAt(row, column.getColumn());
            String notifierValue = notifierCell.getValueAsString();
            if (notifierValue == null || notifierValue.equals("")) return;
            notifierValues.add(notifierValue);
        }
        
        // find the maximum value in the database for the column of this cell, for the value of the nofifier columns
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("where %s=\'%s\'",notifierColumns.get(0).getDbColumn(),notifierValues.get(0)));
        for (int i=1 ; i<notifierValues.size() ; ++i){
            builder.append(String.format("and %s=\'%s\'",notifierColumns.get(i).getDbColumn(),notifierValues.get(i)));
        }
        
        // get the largest integer from the database
        int max=0;
        String sql = String.format("Select max(%s) max from %s %s",
                this.getDBColumn(),this.getDBTable(),builder.toString());
        try {
            ResultSet rs = MySql.getMySql().execute(sql);
            boolean b = rs.next();
            max = rs.getInt("max");  // returns zero if no records for the key;
        } catch (Exception exc){
            exc.printStackTrace();
        }
        
        // also look at the keys in the spreadsheet in case there have been additions
        int n = this.model.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            boolean match = true;
            for (int c=0 ; c<notifierColumns.size() ; ++c){
                Column notifierColumn = notifierColumns.get(c);
                String notifierValue = notifierValues.get(c);
                
                CellBase base = (CellBase)this.model.getValueAt(r,notifierColumn.getColumn());
                String cellKey = base.getValueAsString();

                if (cellKey.equals("") || !cellKey.equals(notifierValue)){
                    match = false;
                    break;
                }
            }
            if (match){
                String cellCount = ((CellBase)this.model.getValueAt(r,getColumn())).getValueAsString();
                if (!cellCount.equals("")){
                    int count = Integer.valueOf(cellCount);
                    if (max < count) max = count;
                }
            }
        }
        this.setValue(Integer.toString(max+1));        
    }    
}
