/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class StringListCell extends CellBase  {
    public StringListCell(){
        this("");
    }
    
    public StringListCell(String strList){
        super(new ArrayList<String>());
        List<String> vList = (List<String>)this.getValue();
        if (!strList.equals("")){
            String[] tokens = strList.split("\t");
            vList.addAll(Arrays.asList(tokens));
        }
    }

    @Override
    public boolean validate(String newValue) {
        return true;
    }

    @Override
    public String getValueAsString() {
        StringBuilder builder = new StringBuilder();
        List<String> vList = (List<String>)this.getValue();
        if (!vList.isEmpty()){
            builder.append(vList.get(0));
            for (int i=1 ; i<vList.size() ; ++i){
                builder.append(',');
                builder.append(vList.get(i));
            }
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Object o) {
        StringListCell other = (StringListCell)o;
        return this.getValueAsString().compareTo(other.getValueAsString());
    }
    
}
