/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq.views;

import java.awt.BorderLayout;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

/**
 *
 * @author gevirl
 */
public class MatrixTablePanel extends JPanel {
    public MatrixTablePanel(String title,String[] cols,TreeMap<String,double[]> dataMap){
        String[] rows = dataMap.keySet().toArray(new String[0]);
        double[][] data = new double[rows.length][];
        for (int i=0 ; i<rows.length ; ++i){
            data[i] = dataMap.get(rows[i]);
        }
        init(title,rows,cols,data);
    }
    public MatrixTablePanel(String title,String[] rows,String[] cols,double[][] data){
        init(title,rows,cols,data);
    }
    final public void init(String title,String[] rows,String[] cols,double[][] data){
        this.setLayout(new BorderLayout());
        
        DefaultTableModel model = new DefaultTableModel();
        table = new JTable(model);
        table.setAutoCreateRowSorter(true);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);          
        TableRowSorter sorter = (TableRowSorter)table.getRowSorter();
        model.addColumn(title);
        for (int i=0 ; i<cols.length ; ++i){
            model.addColumn(cols[i]);
            
        }
        for (int i=1 ; i<=cols.length ; ++i){
            sorter.setComparator(i, new Comparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    Double d1 = (Double)o1;
                    Double d2 = (Double)o2;
                    return d1.compareTo(d2);
                }
            });            
        }
        model.setRowCount(rows.length);
        for (int r=0 ; r<rows.length ; ++r){
            model.setValueAt(rows[r], r, 0);
            for (int c=0 ; c<cols.length ; ++c){
                model.setValueAt(data[r][c], r, c+1);
            }
        }
        
        
      
        JScrollPane scroll = new JScrollPane(table);
        this.add(scroll,BorderLayout.CENTER);
    }
    public void print(String sep,File file) throws Exception{
        PrintWriter writer = new PrintWriter(file);
        
        // print the column names
        int n = table.getColumnCount();
        writer.printf("%s",table.getColumnName(0));
        for (int i=1 ; i<n ; ++i){
            writer.printf("%s%s",sep,table.getColumnName(i));
        }
        writer.println();
        
        int nRows = table.getRowCount();
        for (int r=0 ; r<nRows ; ++r){
            writer.printf("%s",table.getValueAt(r, 0));
            for (int c=1 ; c<n ; ++c){
                writer.printf("%s%.3f",sep,(Double)table.getValueAt(r, c));
            }
            writer.println();
        }
        writer.close();
    }
    JTable table;
    
}
