/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq.views;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;

/**
 *
 * @author gevirl
 */
public class MatrixDisplayFrame extends JFrame {
    public MatrixDisplayFrame(){
        
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        
        tabPane = new JTabbedPane();

        JMenu menu = new JMenu("File");
        JMenuItem print = new JMenuItem("Print");
        menu.add(print);
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MatrixTablePanel table = (MatrixTablePanel)tabPane.getSelectedComponent();
                    JFileChooser chooser = new JFileChooser();
                    if (chooser.showSaveDialog(table)==JFileChooser.APPROVE_OPTION){
                        table.print(",",chooser.getSelectedFile());
                    }
                    
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        JMenuBar bar = new JMenuBar();
        bar.add(menu);
        this.setJMenuBar(bar);
        
        this.add(tabPane,BorderLayout.CENTER);
        this.pack();
        this.setSize(500,500);
        
    }
    public void addTab(String[] rows,String[] cols,double[][] dataMap,String title){
        MatrixTablePanel table = new MatrixTablePanel(title,rows,cols,dataMap);
        tabPane.add(title, table );
    }
    public void addTab(String[] cols,TreeMap<String,double[]> dataMap,String title){
        MatrixTablePanel table = new MatrixTablePanel(title,cols,dataMap);
        tabPane.add(title, table );
    }    
    JTabbedPane tabPane;
}
