/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq.merged;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.RNASeq.GridSubmitOld;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.db.MySql;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class MergedID extends TextCell implements GridSubmittable  {
    public MergedID(){
        super();
        inputs.put("Directory",null);
        inputs.put("InputBAMs",null);
        inputs.put("LibraryID",null);
        inputs.put("MergeSubmitted",null);
        inputs.put("MergeCompleted",null);
        inputs.put("DupCalcSubmitted",null);
        inputs.put("DupRemoveSubmitted",null);
        inputs.put("DupRemoveCompleted",null);
        inputs.put("PCRDupRate",null);
        inputs.put("DupsRemoved", null);
        inputs.put("GenomeReads",null);
        inputs.put("GenomeUniqueReads",null);
        inputs.put("XomeReads",null);
        inputs.put("rRNAReads",null);
        inputs.put("ReadCountSubmitted", null);
        inputs.put("GenomeBAM",null);
    }
    @Override
    public void submit(String program, int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        String dir = inputs.get("Directory").getValueAsString();
        File dirFile = new File(dir);
        String mergedID = this.getValueAsString();
        
        GridSubmit gs = new GridSubmit(mergedID,program,dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();
        if (program.equals("Merge")) {
            submitMerge(gs,qsubStream);
        } else if (program.equals("CalcDupRate")){
            if (inputs.get("MergeCompleted").getValueAsString().equals("")){
                JOptionPane.showMessageDialog(panel,String.format("Merge has not been completed for %s\nDup Rate Calculation Not Submitted",this.getValueAsString()));
                return;                
            }
            submitDupRateCalc(gs,qsubStream);
        } else if (program.equals("RemoveDups")){
            if (inputs.get("PCRDupRate").getValueAsString().equals("")){
                JOptionPane.showMessageDialog(panel,String.format("PCR Duplication Rate has not been calculated for %s\nRemoval Not Submitted",this.getValueAsString()));
                return;
            }
            submitDupRemoval( gs,qsubStream) ;
        } else if (program.equals("ReadCounts")){
            if (inputs.get("MergeCompleted").getValueAsString().equals("")){
                JOptionPane.showMessageDialog(panel,String.format("Merge has not been completed for %s\nRead Counting Not Submitted",this.getValueAsString()));
                return;                
            } 
            submitReadCounts( gs,qsubStream) ;
        } else if (program.equals("BigWig")){
            submitBigWig(gs,qsubStream);
        }
        else if (program.equals("UniqueReads")){
            submitUniqueReads(gs,qsubStream);
        }
        else if (program.equals("ExonCounts")){
            String genomeBAM = inputs.get("GenomeBAM").getValueAsString();
            onlyExonCounts(genomeBAM,gs,qsubStream);
            String uniqueBAM = genomeBAM.replace("out.bam", "unique.bam");
            onlyExonCounts(uniqueBAM,gs,qsubStream);
int ioashdfuisd=0;
        }        
        gs.run();
    }  
    public void onlyExonCounts(String genomeBAM,GridSubmit gs,PrintWriter writer) throws Exception{
        String id = this.getValueAsString();
        String label = "WS260";
        
        String nameSortedBAM = genomeBAM.replace(".bam",".name.sorted.bam");
        String exonicBAM = nameSortedBAM.replace(".bam", "."+label+".exonic.bam");
        String coordBAM = exonicBAM.replace("name.sorted", "coord.sorted");
        
        String wig = coordBAM.replace(".bam", ".wig");
        String scaledWig = wig.replace(".wig", ".scaled.wig");
        String bigWig = wig.replace(".wig", ".bw");
        String bedGraph = bigWig.replace(".bw", ".bedGraph");
        
        String epicBWFile;
        if (genomeBAM.contains("unique")){
            epicBWFile = String.format("%s.unique.wormbase.bw", id);
        } else {
            epicBWFile = String.format("%s.all.wormbase.bw", id);
        }
        String epicBedGraph = epicBWFile.replace(".bw", ".bedGraph");
        
        writer.println("module load samtools/latest");  
        
        // sort the genomic alignment by name and HI attribute
        // this puts read mate pairs together
        writer.println("rm -f *tmp*bam");
        writer.printf("samtools sort -n -O BAM -t HI -@ 3 -o %s %s\n",nameSortedBAM, genomeBAM);
 
        // filter out alignments that are not completely exonic  -- the original
        String gff = "/net/waterston/vol9/References/WS260/NonOverlappingExons.gff3";
        ArrayList<String> args = new ArrayList<>();
        args.add(nameSortedBAM);
        args.add(gff);
        args.add(exonicBAM);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar", "org.rhwlab.LMS.RNASeq.merged.ExonicBam", args); 
        
        // calculate exon coverage
        args.clear();
        args.add(exonicBAM);
        args.add(gff);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar", "org.rhwlab.LMS.RNASeq.merged.ExonSummary", args); 
        

    }    
    public void submitExonCounts(String genomeBAM,GridSubmit gs,PrintWriter writer) throws Exception{
        String id = this.getValueAsString();
        String label = "Ensembl";
        
        String nameSortedBAM = genomeBAM.replace(".bam",".name.sorted.bam");
        String exonicBAM = nameSortedBAM.replace(".bam", "."+label+".exonic.bam");
        String coordBAM = exonicBAM.replace("name.sorted", "coord.sorted");
        
        String wig = coordBAM.replace(".bam", ".wig");
        String scaledWig = wig.replace(".wig", ".scaled.wig");
        String bigWig = wig.replace(".wig", ".bw");
        String bedGraph = bigWig.replace(".bw", ".bedGraph");
        
        String epicBWFile;
        if (genomeBAM.contains("unique")){
            epicBWFile = String.format("%s.unique.wormbase.bw", id);
        } else {
            epicBWFile = String.format("%s.all.wormbase.bw", id);
        }
        String epicBedGraph = epicBWFile.replace(".bw", ".bedGraph");
        
        writer.println("module load samtools/latest");  
        
        // sort the genomic alignment by name and HI attribute
        // this puts read mate pairs together
        writer.println("rm -f *tmp*bam");
        writer.printf("samtools sort -n -O BAM -t HI -@ 3 -o %s %s\n",nameSortedBAM, genomeBAM);
 /*       
        // filter out alignments that are not completely exonic  -- requested by Brent
        ArrayList<String> args = new ArrayList<>();
        args.add(nameSortedBAM);
        args.add("/net/waterston/vol2/home/lhillier/C_elegans/bge/adam/gtf/c_elegans.PRJNA13758.WS245.annotations.wormbase.locus_and_biotype.protein-coding.exons.nm_wchr.gtf.no_overlap_both_strands");
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar", "org.rhwlab.LMS.RNASeq.merged.ExonicBam", args); 
*/        
 
        // filter out alignments that are not completely exonic  -- the original
        String gff = "/net/waterston/vol9/References/Ensembl/NonOverlappingExons.gff3";
        ArrayList<String> args = new ArrayList<>();
        args.add(nameSortedBAM);
        args.add(gff);
        args.add(exonicBAM);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar", "org.rhwlab.LMS.RNASeq.merged.ExonicBam", args); 
        
        // calculate exon coverage
        args.clear();
        args.add(exonicBAM);
        args.add(gff);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar", "org.rhwlab.LMS.RNASeq.merged.ExonSummary", args); 
        
        // sort by coordinate so that a wig can be made
        writer.printf("samtools sort -O BAM -@ 3 -o %s %s\n", coordBAM,exonicBAM);
        
        // form the wig
        writer.println("module load java/8u25");
        writer.printf("java -jar /net/waterston/vol9/bam2wig.jar -w 1 -s 1 -t -o %s %s\n",wig,coordBAM);
        
        // scale the wig by the genomic aligned reads
        double scale = 20000000.0/Double.valueOf(inputs.get("GenomeReads").getValueAsString());  
        writer.printf("java -cp /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.RNASeq.merged.MergedID %s %f %s\n",wig,scale,scaledWig);
        
        // convert to bigWig
        writer.printf("/net/waterston/vol9/wigToBigWig -clip %s /net/waterston/vol9/ce11.chrom.sizes %s\n",scaledWig,bigWig);        
        
        // make the bedGraph
        writer.printf("/net/waterston/vol9/bigWigToBedGraph  %s  %s\n",bigWig,bedGraph);
        
        // remove the intermediate bams
        writer.printf("rm -f %s \n", nameSortedBAM);
//        writer.printf("rm -f %s \n", exonicBAM);
//        writer.printf("rm -f %s \n", culledBAM);
        writer.printf("rm -f %s \n", coordBAM);
        writer.printf("rm -f %s \n", scaledWig);
        
        // move the bigWig and bedGraphto epic
        writer.printf("ssh epic.gs.washington.edu mv %s /data/www/site/waterston/html/FACS/%s \n",bigWig,epicBWFile);
        writer.printf("ssh epic.gs.washington.edu mv %s /data/www/site/waterston/html/FACS/%s \n",bedGraph,epicBedGraph);

    }
    public void submitBigWig(GridSubmit gs,PrintWriter writer) throws Exception{
        File script = buildBigWig();
        writer.println(script.getPath());
    }
    public void stateChanged(ChangeEvent event){
        String unique = ((CellBase)event.getSource()).getValueAsString();
        String library = inputs.get("LibraryID").getValueAsString();
        if (library.equals(""))return;

        this.setValue(String.format("%s_Merged%s",library,unique));
    }  
    public void submitUniqueReads(GridSubmit gs,PrintWriter writer) throws Exception{
        String dir = inputs.get("Directory").getValueAsString();
        String mergeID = this.getValueAsString();
        File bam = new File(dir,"Aligned.toGenome.out.bam");
        File sortedBam = new File(dir,"Aligned.toGenome.sort.bam"); 
        
        // sort the geneome bam file
        writer.println("module load samtools/latest");
 //       writer.printf("samtools sort --threads 4 %s > %s \n",bam.getPath(),sortedBam.getPath());    
        
        ArrayList<String> args = new ArrayList<>();
        args.add(mergeID);
        args.add(sortedBam.getPath());
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar", "org.rhwlab.LMS.RNASeq.merged.UniqueMergedBam", args);      
        
        writer.printf("mv -f %s %s\n", sortedBam.getPath(),bam.getPath());
    }
    public void submitReadCounts(GridSubmit gs,PrintWriter writer) throws Exception{
        String mergeID = this.getValueAsString();
        // update the reads counts
        ArrayList<String> args = new ArrayList<>();
        args.add(mergeID);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar", "org.rhwlab.LMS.RNASeq.merged.BAMs", args); 
        inputs.get("ReadCountSubmitted").setValue(new Date()); 
        inputs.get("GenomeReads").setValue(null);
        inputs.get("XomeReads").setValue(null);
        inputs.get("rRNAReads").setValue(null);        
    }
    public void submitDupRemoval(GridSubmit gs,PrintWriter writer) throws Exception{
        String mergeID = this.getValueAsString();

        writer.println("module load samtools/latest");
        writer.printf("samtools view -h Aligned.toGenome.out.bam | /net/waterston/vol9/rmdupsam - seldup.out.rmdup.lst 2> genome.rmdupsam.out | samtools view -b -o genome.bam\n");
        writer.printf("samtools view -h Aligned.toTranscriptome.out.bam | /net/waterston/vol9/rmdupsam - seldup.out.rmdup.lst 2> xome.rmdupsam.out | samtools view -b -o xome.bam\n");

        writer.println("echo \"Starting RNASeqFinisher\"");
        ArrayList<String> args = new ArrayList<>();
        args.add(mergeID);
        args.add("RemoveDup");
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.RNASeq.Finisher" , args);
        
        inputs.get("DupRemoveSubmitted").setValue(new Date());  
        inputs.get("DupRemoveCompleted").setValue(null);
        
    }
    public void submitDupRateCalc(GridSubmit gs,PrintWriter writer) throws Exception {
        String mergeID = this.getValueAsString();
        String directory = inputs.get("Directory").getValueAsString();
        
        writer.println("echo \"Starting Seldup\"");        
        writer.printf("/net/waterston/vol9/seldup %s seldup.out 1 2\n",new File(directory,"Aligned.toGenome.out.bam").getPath());

        writer.println("echo \"Starting RNASeqFinisher\"");
        ArrayList<String> args = new ArrayList<>();
        args.add(mergeID);
        args.add("Seldup");
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.RNASeq.Finisher" , args);
        
        inputs.get("DupCalcSubmitted").setValue(new Date());  
        inputs.get("PCRDupRate").setValue(null);
        inputs.get("DupRemoveSubmitted").setValue(null);
        inputs.get("DupRemoveCompleted").setValue(null);        
    }
    public void submitMerge(GridSubmit gs,PrintWriter writer)throws Exception {
        String mergeID = this.getValueAsString();
        
        org.rhwlab.LMS.RNASeq.Bams bams = (org.rhwlab.LMS.RNASeq.Bams)inputs.get("InputBAMs");
        ArrayList<String> genomeBams = new ArrayList<>();
        ArrayList<String> xomeBams = new ArrayList<>();
        for (String bam : bams.getBAMFiles()){
            if (bam.contains("Transcriptome")){
                xomeBams.add(bam);
            } else {
                genomeBams.add(bam);
            }
        }        
        String directory = inputs.get("Directory").getValueAsString();
        
        String xomeFileName = new File(xomeBams.get(0)).getName();
        File xomeOut = new File(directory,xomeFileName);
        String genomeFileName = new File(genomeBams.get(0)).getName();
        File genomeOut = new File(directory,genomeFileName);
        

        writer.println("module load samtools/latest");
        
        writer.printf("samtools cat -o %s", xomeOut.getPath());
        for (String bam : xomeBams){
            writer.printf(" %s",bam);
        }
        writer.println();
        writer.printf("samtools cat -o %s", genomeOut.getPath());
        for (String bam : genomeBams){
            writer.printf(" %s",bam);
        }
        writer.println();  
        
        // sort the genome alignment by coordinate
        File newFile = new File(directory,"Aligned.toGenome.out.bam");
        writer.printf("samtools sort -O BAM %s > %s \n",genomeOut.getPath(),newFile.getPath());
        writer.printf("rm -f %s \n",genomeOut.getPath());
        
        // run the finisher
        ArrayList<String> args = new ArrayList<>();
        args.add(mergeID);
        args.add("MergeBAMs");
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.RNASeq.Finisher" , args);
        
        writer.close();
        inputs.get("MergeSubmitted").setValue(new Date()); 
        inputs.get("MergeCompleted").setValue(null);
        inputs.get("DupCalcSubmitted").setValue(null);
        inputs.get("PCRDupRate").setValue(null);
        inputs.get("DupRemoveSubmitted").setValue(null);
        inputs.get("DupRemoveCompleted").setValue(null);
        inputs.get("GenomeReads").setValue(null);
        inputs.get("XomeReads").setValue(null);
        inputs.get("rRNAReads").setValue(null);
    }    
    static public String getDirectory(String mergeID)throws Exception {
        String sql = String.format("Select * from RNASeqMerged where MergedID = \'%s\'",mergeID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String user = rs.getString("UserName");
            String dataset = rs.getString("DataSet");
            String libraryID = rs.getString("LibraryID");
            String count = Integer.toString(rs.getInt("MergedCount"));
            return Directory.getDirectory(user, dataset, libraryID, count);

        }
        return null;        
    }
    static public String getSpecies(String mergedID)throws Exception {
        String sql = String.format("Select * from RNASeqMerged where MergedID = \'%s\'",mergedID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("Species");
        }
        return null;        
    }
    static public void updateBAMDate(String id,String dbcol)throws Exception {
        File mergeDir = new File(getDirectory(id));
        File[] files = mergeDir.listFiles();
        long latest = 0;
        for (File file : files){
            if (file.getPath().endsWith("bam")){
                long last = file.lastModified();
                if (last > latest){
                    latest = last;
                }
            }
        }
        if (latest > 0){
            java.sql.Timestamp sqlTime = new java.sql.Timestamp(latest);
            String sql = String.format("Update RNASeqMerged set %s = ? where MergedID = ?",dbcol);
            PreparedStatement state = MySql.getMySql().getStatement(sql);
            state.setTimestamp(1, sqlTime);
            state.setString(2,id);
            state.execute();
        }   
    } 


    // construct a bigWig from this alignment
    public File buildBigWig()throws Exception {
        String dir = inputs.get("Directory").getValueAsString();
        File dirFile = new File(dir);
        String id = this.getValueAsString();
        
        File script = new File(dir,"buildBigWig.sh");
        PrintStream stream = new PrintStream(script);
        stream.println("module load java/8u25");
        stream.println("module load samtools/latest");     
        
        for (File file : dirFile.listFiles()){
            if (file.getName().endsWith("bam") && file.getName().contains("Genome")){
                
                File bam = file;
                File wig;
                File bigWig;
                File unscaled = new File(dir,"unscaled.wig");
                File bedGraph;
                double scale = 20000000.0;
                if (bam.getName().contains("unique")){
                    scale = scale/Double.valueOf(inputs.get("GenomeUniqueReads").getValueAsString());
                    wig = new File(dir,String.format("%s.unique.wig",id));
                    bigWig = new File(dir,String.format("%s.unique.bw",id));   
                    bedGraph = new File(dir,String.format("%s.unique.bedGraph",id)); 
                } else {
                    scale = scale/Double.valueOf(inputs.get("GenomeReads").getValueAsString());
                    wig = new File(dir,String.format("%s.wig",id));
                    bigWig = new File(dir,String.format("%s.bw",id)); 
                    bedGraph =  new File(dir,String.format("%s.bedGraph",id));                    
                }

                // form the wig of all reads
                stream.printf("java -jar /net/waterston/vol9/bam2wig.jar -w 1 -s 1 -t -o %s %s\n",unscaled.getPath(),bam.getPath());

                // scale it by total aligned reads
                stream.printf("java -cp /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.RNASeq.merged.MergedID %s %f %s\n",
                        unscaled.getPath(),scale,wig.getPath());
            
                // convert to bigWig
                stream.printf("/net/waterston/vol9/wigToBigWig -clip %s /net/waterston/vol9/ce11.chrom.sizes %s\n",wig.getPath(),bigWig.getPath());
            
                // form a bedGraph
                stream.printf("/net/waterston/vol9/bigWigToBedGraph  %s  %s\n",bigWig.getPath(),bedGraph.getPath());
                // clean up 
                stream.printf("rm -f %s \n", unscaled.getPath());
            }
        }
        // move the bigWigs and bedGraphs to epic
        stream.printf("ssh epic.gs.washington.edu mv %s/*.bw %s/*.bedGraph /data/www/site/waterston/html/FACS/ \n",dirFile.getPath(), dirFile.getPath());
        stream.close();
        script.setExecutable(true, false);
        return script;
    }
    
    static public void scaleWig(File wig,double scale,File out)throws Exception {
        PrintStream outStream = new PrintStream(out);
        BufferedReader reader = new BufferedReader(new FileReader(wig));
        
        String line = reader.readLine(); 
        outStream.println(line);  // skip the header
        
        line = reader.readLine();
        while (line != null){
            if (!line.startsWith("fixed")){
                double value = Double.valueOf(line);
                value = value*scale;outStream.printf("%.2f\n", value);
            } else {
                outStream.println(line);
            }
            line = reader.readLine();
        }
        reader.close();;
        outStream.close();
    }
    
    // scale a wig file
    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File output = new File(args[2]);
        double scale = Double.valueOf(args[1]);
        MergedID.scaleWig(input, scale, output);
    }

}
