/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq.merged;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.RNASeq.AlignReference;
import org.rhwlab.LMS.RNASeq.AlignmentReference;
import static org.rhwlab.LMS.RNASeq.ExpressionID.getLibraryID;
import org.rhwlab.LMS.RNASeq.FeatureGroup;
import org.rhwlab.LMS.RNASeq.GeneCountFeatureGroup;
import org.rhwlab.LMS.RNASeq.GridSubmitOld;
import org.rhwlab.LMS.RNASeq.LibraryID;
import org.rhwlab.LMS.RNASeq.Reference;
import org.rhwlab.LMS.RNASeq.SampleID;
import org.rhwlab.LMS.RNASeq.TpmFeatureGroup;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.db.MySql;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class ExpressionID extends TextCell implements GridSubmittable {
    public ExpressionID(){
        super();
        inputs.put("ExpressionBy",null);
        inputs.put("Directory",null);
        inputs.put("ExpressionSubmitted", null);
        inputs.put("ExpressionCompleted", null);
        inputs.put("Species", null);
        inputs.put("Reference",null);
        inputs.put("MergedID",null);
    }
    static public Integer getSampleTime(String expID)throws Exception {
        String libraryID = getLibraryID(expID);
        if (libraryID == null) return null;
        
        String sampleID = LibraryID.getSampleID(libraryID);
        if (sampleID == null) return null;
        
        String stage = SampleID.getStage(sampleID);
        if (stage == null)return null;
        
        try{
            Integer ret = new Integer(stage);
            return ret;
        } catch (Exception exc){
            return null;
        }
    }    
    static public String getReference(String ID)throws Exception {
        String sql = String.format("Select Reference from RNASeqMergedExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("Reference");
        } else {
            return null;
        }
    }      
    static public String expressionFile(String ID,FeatureGroup feature,boolean polyA)throws Exception {
        String sql = String.format("Select Directory,ExpressionBy from RNASeqMergedExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String dir = rs.getString("Directory");
            String by = rs.getString("ExpressionBy");
            if (by.contains("BitSeq")){
                String filename = String.format("%s/%s",dir,feature.BitSeqFile(ID));
                if (polyA){
                    filename = filename.replace("rpkm", "polyA.rpkm");
                }
                return filename;
            } else {
                return String.format("%s/%s",dir,"HTSeq.out.csv");
            }
        } else {
            return null;
        } 
       
    }     
     static public String countsExpressionFile(String ID,GeneCountFeatureGroup feature,String mapper)throws Exception {
        String sql = String.format("Select Directory,ExpressionBy from RNASeqMergedExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String dir = rs.getString("Directory");
            String by = rs.getString("ExpressionBy");
            if (by.contains("HTSeq")){
//                String filename = feature.HTSeqFile(mapper);
                String filename = "HTSeq.out.csv";
                return new File(dir,filename).getPath();
            }
        }
        return null;
     }
    static public String tpmExpressionFile(String ID,TpmFeatureGroup feature,String level)throws Exception {
        String sql = String.format("Select Directory,ExpressionBy from RNASeqMergedExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String dir = rs.getString("Directory");
            String by = rs.getString("ExpressionBy");
            if (by.contains("BitSeq")){
                String filename = feature.BitSeqFile(ID,level);
 
                return new File(dir,filename).getPath();
            } else {
                return String.format("%s/%s",dir,"HTSeq.out.csv");
            }
        } else {
            return null;
        } 
       
    }      
    static public String getDirectory(String ID)throws Exception {
        String sql = String.format("Select Directory from RNASeqMergedExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("Directory");
        } else {
            return null;
        }
    }    
    public void stateChanged(ChangeEvent event){
        String mergedID = inputs.get("MergedID").getValueAsString();
        if (mergedID.equals(""))return;
        String expressBy = inputs.get("ExpressionBy").getValueAsString();
        if (expressBy.equals(""))return;        

        this.setValue(String.format("%s_%s",expressBy,mergedID));
    } 
    public void submit() throws Exception{ 
        String species = inputs.get("Species").getValueAsString();
        String program = inputs.get("ExpressionBy").getValueAsString();
        String expressID = this.getValueAsString();
        String directory = inputs.get("Directory").getValueAsString();
        File expDirectory = new File(directory);
        expDirectory.mkdir();
        
        File mergeDirectory = expDirectory.getParentFile();
        File mergedBam = new File(mergeDirectory,"Aligned.toTranscriptome.out.bam");       
        File filterBam = new File(directory,"xome.bam");
 //       File sortedBam = new File(directory,"xome.sorted.bam");
        
        File qsub = GridSubmitOld.qsubFile(expressID,program);
        File script = GridSubmitOld.scriptFile(expressID,program, "");
        GridSubmitOld.writeScriptFile(script, new File(directory), qsub); 
        PrintWriter writer;   
        
        if (program.contains("BitSeq")){
            writer = GridSubmitOld.initializeQsub(qsub, LabMan.gridMemory.get("BitSeq"), 100,LabMan.grid);
            bitseq(writer,program,species,mergedBam,filterBam);
        } else {
            writer = GridSubmitOld.initializeQsub(qsub, LabMan.gridMemory.get("HTSeq"), 100,LabMan.grid);
            mergedBam = new File(mergeDirectory,"Aligned.sortedByCoord.out.bam");
            htseq(writer,mergedBam,species,expDirectory);
        }
        
        GridSubmitOld.runFinisher(writer, program, expressID,20);
        writer.close();
               
        GridSubmitOld.startSubmission(script.getPath());
        
        inputs.get("ExpressionSubmitted").setValue(new Date());  
        inputs.get("ExpressionCompleted").setValue(null);
           
    }
    private void htseq(PrintWriter writer,File bamFile,String species,File expDir)throws Exception {
        Reference reference = AlignmentReference.getReference(inputs.get("Reference").getValueAsString());
        String stranded = "no";
        if (species.equals("Dmel")){
            stranded = "yes";
        }     
        writer.printf("cd %s\n",expDir.getPath());
        writer.println("module load samtools/latest");
        writer.println("module load python/3.5.2");
        writer.printf("samtools sort -n %s >  genome.sorted.bam \n",bamFile.getPath());
        writer.println("PYTHONPATH=$PYTHONPATH:/net/waterston/vol9/htseq");
/*
        writer.printf("python /net/waterston/vol9/htseq/HTSeq/scripts/count.py -f bam  -s %s -t gene -i Name genome.sorted.bam %s > HTSeq.out \n",
                stranded,reference.getGFF());
        writer.printf("python /net/waterston/vol9/htseq/HTSeq/scripts/count.py --nonunique=all -f bam  -s %s -t gene -i Name genome.sorted.bam %s > HTSeq.all.out \n",
                stranded,reference.getGFF());         
*/        
        writer.printf("python /net/waterston/vol9/htseq/HTSeq/scripts/count.py -f bam  -s %s -t exon -i gene_id genome.sorted.bam %s > HTSeq.out \n",
                stranded,reference.getGTF());
        writer.printf("python /net/waterston/vol9/htseq/HTSeq/scripts/count.py --nonunique=all -f bam  -s %s -t exon -i gene_id genome.sorted.bam %s > HTSeq.all.out \n",
                stranded,reference.getGTF());           
 /*       
        writer.println("module load python/2.7.3 six/1.10.0 numpy/1.8.1 matplotlib/1.3.1 HTSeq/0.6.1p1 pysam/0.8.4 ");
        writer.printf("samtools sort -n %s >  genome.sorted.bam \n",bamFile.getPath());
        writer.printf("python /net/waterston/vol9/HTSeq-0.6.1/scripts/htseq-count -f bam  -s %s -t gene -i Name genome.sorted.bam %s > HTSeq.out \n",
                stranded,reference.getGFF());
        writer.printf("python /net/waterston/vol9/HTSeq-0.6.1/scripts/htseq-count --nonunique=all -f bam  -s %s -t gene -i Name genome.sorted.bam %s > HTSeq.all.out \n",
                stranded,reference.getGFF());                
        writer.println("rm -f genome.sorted.bam");
*/
    }    

    private void  bitseq(PrintWriter writer,String program,String species,File mergedBam,File filterBam)throws Exception {
        makeRscript(filterBam);
        
        boolean ribo = program.startsWith("RiboZero");
        boolean polyA = program.startsWith("PolyA");
        String ribosomal = Boolean.toString(ribo||polyA);
        String histone = Boolean.toString(polyA); 
        writer.println("module load java/8u25"); 
        writer.printf("java -classpath /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.RNASeq.Bams %s %s %s %s %s\n",
                histone,ribosomal,filterBam.getPath(),species,mergedBam.getPath());
        writer.println("echo \"Starting BitSeq\""); 
        writer.println("module load hdf5/1.8.13");
        writer.println("module load netcdf/4.3.2");
        writer.println("module load gmp/5.0.2 mpfr/3.1.0 mpc/0.8.2  gcc/4.9.1 R/3.3.0");
        writer.println("module load samtools/latest");
        writer.printf("cd %s\n",filterBam.getParent());
        writer.println("rm -f data.tr");
        writer.println("R -f BitSeq.R");    
    }
    private void makeRscript(File bamFile)throws Exception {
        AlignReference ref = (AlignReference)inputs.get("Reference");
        String expID = this.getValueAsString();
        // build the R file
        File rFile = new File(bamFile.getParent(),"BitSeq.R");
        rFile.setReadable(true,false);
        rFile.setExecutable(true, false);
        rFile.setWritable(true, false);
        
        PrintWriter writer = new PrintWriter(rFile);
        writer.println(".libPaths()");
        writer.println(".libPaths(\"/net/waterston/vol9/R_Packages/3.3\")");
        writer.println("library(BitSeq)");
        writer.printf("parseAlignment(\"%s\" ,",bamFile.getPath());
        writer.printf("outFile = \"%s.prob\" ,\n",expID);

        // only have worm transcript fasta
        writer.printf("trSeqFile = \"%s\", \n",ref.getBitSeqXome());
        writer.println("trInfoFile = \"data.tr\", ");
//        writer.println("lenMu = 4.7 , ");
//        writer.println("lenSigma = 5.0e-05 , ");
        writer.println("uniform = TRUE, ");
        writer.println("verbose = TRUE, ");
        writer.println("veryVerbose = TRUE )");
        
        writer.printf("estimateExpression(\"%s.prob\" , outFile = \"%s\" , \n",expID,expID);
        writer.println("outputType = \"RPKM\" , trInfoFile = \"data.tr\" ,");
        writer.println("MCMC_burnIn = 1000 , MCMC_samplesN = 1000 , MCMC_samplesSave = 1000 , MCMC_chainsN = 2)");
        writer.close();        
    }

    @Override
    public void submit(String program, int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        AlignReference ref = (AlignReference)inputs.get("Reference");
        String species = inputs.get("Species").getValueAsString();
        String expressBy = inputs.get("ExpressionBy").getValueAsString();
        String expressID = this.getValueAsString();
        
        String dir = inputs.get("Directory").getValueAsString();
        File expDir = new File(dir);        
        File mergeDirectory = expDir.getParentFile();
        File mergedBam = new File(mergeDirectory,"Aligned.toTranscriptome.out.bam");  
        File genomeBam = new File(mergeDirectory,"Aligned.toGenome.out.bam");
        File filterBam = new File(expDir,"xome.sam");   

        
        GridSubmit gs = new GridSubmit(expressID,program,expDir);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();
        if (expressBy.contains("BitSeq")){
            ArrayList<String> args = new ArrayList<>();
            args.add(mergedBam.getPath());
            args.add(ref.getBitSeqXome());
            args.add(filterBam.getPath());
            args.add(species);
            gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar", "org.rhwlab.LMS.RNASeq.merged.ExpressionID", args);
            qsubStream.println("echo \"Starting BitSeq\""); 
            qsubStream.println("module load hdf5/1.8.13");
            qsubStream.println("module load netcdf/4.3.2");
            qsubStream.println("module load gmp/5.0.2 mpfr/3.1.0 mpc/0.8.2  gcc/4.9.1 R/3.3.0");
            qsubStream.println("module load samtools/latest");
            qsubStream.println("rm -f data.tr");
            qsubStream.println("R -f BitSeq.R");  
            
            ArrayList<String> fargs = new ArrayList();
            fargs.add(expressID);
            fargs.add("BitSeq");
            gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.RNASeq.Finisher" , fargs); 
            
            qsubStream.println("rm -f xome.culled.sam");
            qsubStream.println("rm -f xome.sam");
            qsubStream.println("rm -f *.prob");
            makeRscript(filterBam);
        } else if (expressBy.contains("HTSeq")){
            String stranded = "no";
            if (species.equals("Dmel")){
                stranded = "yes";
            }     
            qsubStream.println("module load samtools/latest");
            qsubStream.println("module load python/3.5.2");
            qsubStream.printf("samtools sort -n %s >  genome.sorted.bam \n",genomeBam.getPath());
            qsubStream.println("PYTHONPATH=$PYTHONPATH:/net/waterston/vol9/htseq");
/*            
            qsubStream.printf("python /net/waterston/vol9/htseq/HTSeq/scripts/count.py -m intersection-nonempty -f bam  -s %s -t gene -i Name genome.sorted.bam %s > HTSeq.out \n",
                    stranded,ref.getHTSeqGFF());
            qsubStream.printf("python /net/waterston/vol9/htseq/HTSeq/scripts/count.py -m intersection-nonempty --nonunique=all -f bam  -s %s -t gene -i Name genome.sorted.bam %s > HTSeq.all.out \n",
                    stranded,ref.getHTSeqGFF());   
 */            
            qsubStream.printf("python /net/waterston/vol9/htseq/HTSeq/scripts/count.py -m intersection-nonempty -f bam  -s %s -t exon -i gene_id genome.sorted.bam %s > HTSeq.out \n",
                    stranded,ref.getHTSeqGTF());
            qsubStream.printf("python /net/waterston/vol9/htseq/HTSeq/scripts/count.py -m intersection-nonempty --nonunique=all -f bam  -s %s -t exon -i gene_id genome.sorted.bam %s > HTSeq.all.out \n",
                    stranded,ref.getHTSeqGTF());  
            
            qsubStream.println("rm -f genome.sorted.bam");
            ArrayList<String> fargs = new ArrayList();
            fargs.add(expressID);
            fargs.add("HTSeq-count");
            gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.RNASeq.Finisher" , fargs);                     
        }
        
        gs.run();
        inputs.get("ExpressionSubmitted").setValue(new Date());  
        inputs.get("ExpressionCompleted").setValue(null);        
    }
    
    // args[0] - input bam
    // args[1] - transcriptome fasta
    // args[2] - output file name
    // args[3] - species
    static public void main(String[] args) {
        // copy alignments from the  input bam that match reference names in a transcriptome sequence fasta
        org.rhwlab.alignment.BAM bam = new org.rhwlab.alignment.BAM(new File(args[0]));
        try {
            Set<String> histoneNames = org.rhwlab.alignment.BAM.getHistoneNames(args[3]);
            int[] reads = bam.keepReads(new File(args[1]),args[2],histoneNames);
            PrintStream stream = new PrintStream(new File(new File(args[2]).getParentFile(),"reads.out"));
            stream.printf("Total Read Count: %d\n",reads[0]);
            stream.printf("Histone Read Count: %d\n",reads[1]);
            stream.close();        
        } catch (Exception exc){
            exc.printStackTrace();
        }

    }
}
