/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq.merged;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.rhwlab.LMS.TextCell;

/**
 *
 * @author gevirl
 */
public class ExpressionDirectory extends TextCell {
    public ExpressionDirectory(){
        super();
        inputs.put("ExpressionBy",null);
        inputs.put("MergedDirectory",null);
        inputs.put("ExpressionID",null);
        if (corr==null) corr = new SpearmansCorrelation();
    }
    public void stateChanged(ChangeEvent event){
        String mergedDir = inputs.get("MergedDirectory").getValueAsString();
        if (mergedDir.equals(""))return;
        String expressBy = inputs.get("ExpressionBy").getValueAsString();
        if (expressBy.equals(""))return;        

        File dir = new File(mergedDir,expressBy);
        this.setValue(dir.getPath());
    } 
   
    static public double[][] autoSpearman(ExpressionDirectory[] dirs,String label)throws Exception {

        double[][] ret = new double[dirs.length][];
        for (int i=0 ; i<dirs.length ; ++i){
            double[] spears = dirs[i].spearman(dirs,label);
            ret[i] = spears;
        }
        
        return ret;
    }
    
    
    // compute the spearmean correlations between this directory expression data and a set of other expression directories
    public double[] spearman(ExpressionDirectory[] other,String label) throws Exception {
        
        List<String[]> dataList = this.readExpressionFile(label);
        TreeMap<String,Double> expMap = new TreeMap<>();
        for (String[] data : dataList){
            expMap.put(data[0],new Double(data[3]));
        }
        
        double[] correlations = new double[other.length];
        for (int i=0 ; i<correlations.length ; ++i){
            List<String[]> otherDataList = other[i].readExpressionFile(label);
            TreeMap<String,Double> otherMap = new TreeMap<>();
            for (String[] data : otherDataList){
                otherMap.put(data[0],new Double(data[3]));
            }
            // find feature name in common
            TreeSet<String> inCommon = new TreeSet<>();
            for (String key : expMap.keySet()){
                if (otherMap.containsKey(key)){
                    inCommon.add(key);
                }
            }
            int j=0;
            double[] d1 = new double[inCommon.size()];
            double[] d2 = new double[inCommon.size()];
            for (String key : inCommon){
                d1[j] = expMap.get(key);
                d2[j] = otherMap.get(key);
                ++j;
            }
            correlations[i] = corr.correlation(d1, d2);
        }
        return correlations;
    }

    // label identifies the feature group file(ie mRNA, genes, etc)
    public List<String[]> readExpressionFile(String label)throws Exception {
        String dir = this.getValueAsString();
        String expID = inputs.get("ExpressionID").getValueAsString();
        String file = String.format("%s/%s.%s.rpkm",dir,expID,label);

        return readFile(file);
    }
    static public List<String[]> readFile(String file) throws Exception {
        ArrayList<String[]> ret = new ArrayList<>();
        BufferedReader reader = new BufferedReader (new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            if (line.charAt(0) != '#'){
                String[] tokens = line.split(" ");
                ret.add(tokens);
            }
            line = reader.readLine();
        }
        reader.close();
        return ret;        
    }
    

    static SpearmansCorrelation corr;    
}
