/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq.md5;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.rhwlab.LMS.JsonCell;

/**
 *
 * @author gevirl
 */
public class MD5sum extends JsonCell {
    public MD5sum() {
        inputs.put("Directory",null);
    }
    public List<String> getBAMFiles(){
        ArrayList<String> ret = new ArrayList<>();
        JsonObject jsonObject = (JsonObject)this.getValue();
        for (String key: jsonObject.keySet()){
            if (key.endsWith("bam")){
                ret.add(key);
            }
        }
        return ret;
    }
    public String getCSVFile(){
        JsonObject jsonObject = (JsonObject)this.getValue();
        for (String key: jsonObject.keySet()){
            if (key.endsWith("csv")){
                return key;
            }
        }
        return null;
    }    
    public List<String> getBigWigFiles(){
        ArrayList<String> ret = new ArrayList<>();
        JsonObject jsonObject = (JsonObject)this.getValue();
        for (String key: jsonObject.keySet()){
            if (key.endsWith("bw")){
                ret.add(key);
            }
        }
        return ret;        
    }
    public String getMD5(String file){
        JsonObject jsonObject = (JsonObject)this.getValue();
        return jsonObject.getString(file,"");
/*        
        for (String key : jsonObject.keySet()){
            File keyFile = new File(key);
            if (keyFile.getName().equals(file)){
                return jsonObject.getString(key);
            }
        }
        return "";
*/        
    }
    public void updateAll()throws Exception{

    }
    // calculate the md5sum of all files with the given extension in the given directory
    // returning results in a json object
    public static JsonObject calculate(String directory,String[] exts)throws Exception {
        File dir = new File(directory);
        if (dir.exists()){
            JsonObjectBuilder builder = Json.createObjectBuilder();
            File[] files = dir.listFiles();
            for (File file : files){
                for (String ext : exts){
                    String path = file.getPath();
                    if (path.endsWith(ext)){
                        String md5 = hashFile(file,"MD5");
                        builder.add(path, md5);
                        break;
                    }
                }

            }
            JsonObject jsonObject = builder.build();
            return jsonObject;
        }
        return null;
    }
    private static String hashFile(File file, String algorithm)throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        MessageDigest digest = MessageDigest.getInstance(algorithm);
 
        byte[] bytesBuffer = new byte[1024];
        int bytesRead = inputStream.read(bytesBuffer);
 
        while (bytesRead  != -1) {
            digest.update(bytesBuffer, 0, bytesRead);
            bytesRead = inputStream.read(bytesBuffer);
        }
 
        byte[] hashedBytes = digest.digest();
 
        return convertByteArrayToHexString(hashedBytes);

}  
    private static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < arrayBytes.length; i++) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xff) + 0x100, 16)
                    .substring(1));
        }
        return stringBuffer.toString();
    }
    
    static public void main(String[] args)throws Exception {
    }
}
