/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.DAG.decomp.Study;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.LMS.JsonCell;
import org.rhwlab.RNASeq.KdeFile;
import org.rhwlab.RNASeq.PMatrixKdeFile;
import org.rhwlab.RNASeq.TimeWarpedDataSource;

/**
 *
 * @author gevirl
 */
public class TimeSeriesMap extends JsonCell {
    public TimeSeriesMap(){
        super();
        inputs.put("UnificationID",null);
        inputs.put("Directory",null);
        inputs.put("Features",null);
        inputs.put("ReferenceTimeSeries",null);
        inputs.put("SampleTime1",null);
        inputs.put("SampleTime2",null);
        inputs.put("DevelTime1",null);
        inputs.put("DevelTime2",null);
        inputs.put("Stages",null);
        inputs.put("StageIncrement",null);
        inputs.put("FirstStage",null);
        inputs.put("Iterations",null);
        inputs.put("BurnIn",null);
        inputs.put("Submitted",null);
        inputs.put("Completed",null);
        inputs.put("DeconvolveIterations",null);
        inputs.put("DeconvolveBurnIn",null);  
        inputs.put("DeconvolveSubmitted",null);
        inputs.put("DeconvolveCompleted",null);        
    }
    public String getDirectory(){
        return inputs.get("Directory").getValueAsString();
    }
    public Study getStudy()throws Exception {
        Study ret = new Study();
        String dir = inputs.get("Directory").getValueAsString();
        String[] ts = getTimeSeries();
        TimeWarpedDataSource source = new TimeWarpedDataSource(new File(dir),ts);
        PMatrixKdeFile pkde = new PMatrixKdeFile(new File(dir,"DeconvolutionConfig").getPath());
        double n = pkde.getValue("NStages","Value");
        source.setPMatrixKDEFile(pkde); 
        double[] times = pkde.getStageTimes((int)n);
        
        ret.setResultFile(new File(dir,"Normalized.out").getPath());
        UnifiedResult result = ret.getUnifiedResult();
        result.setUnifiedTimes(times);
        ret.setSource(source);
        return ret;
    }

    public void submitNormalize()throws Exception {
        uniID = inputs.get("UnificationID").getValueAsString();

        String dir = inputs.get("Directory").getValueAsString();
        uniDir = new File(dir);
        String scriptFile = makeNormalizeScript();
        
        // start the normalization script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();  

    }
    private String makeNormalizeScript()throws Exception {
        File scriptFile = GridSubmitOld.scriptFile(this.uniID,"Unification","Normalize");
        File qsubFile = GridSubmitOld.qsubFile(this.uniID,"Normalize");  
        
         // build the script file for this normalization
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  

        writer.printf("qsub -e %s -o %s %s\n", uniDir.getPath(),uniDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);     
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=16G");
        writer.println("date"); 
        writer.printf("cd %s\n",uniDir.getPath());
        writer.printf("/nfs/waterston/celtdModel/jdk1.7.0/bin/java -jar -Xms4G /nfs/waterston/tools3/Unification.jar Normalize none none %s ",uniDir.getPath()); 
        String[] tsList = getTimeSeries();
        for (String ts : tsList){
            writer.printf(" %s", ts);
        }
        writer.println();
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.println("module load java/8u25");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s Normalize \n",uniID); 
//        writer.printf("chown -R :waterstonlab %s\n",uniDir.getPath());
//        writer.printf("chmod -R 770 %s\n",uniDir.getPath());
        writer.close();        
        return scriptFile.getPath();
    }    
    public void submitDeconvolve()throws Exception {
        uniID = inputs.get("UnificationID").getValueAsString();

        String dir = inputs.get("Directory").getValueAsString();
        uniDir = new File(dir);
        if (!uniDir.exists()) uniDir.mkdirs();

        List<File> dataFiles = buildBitSeqExpressionFiles(FeatureGroup.Genes);
        PrintStream outStream = new PrintStream(new File(uniDir,"DeconvolutionConfig"));
        File kde = new File(dir,"Training.kde");
        buildPMatixInitializationFile(outStream,inputs.get("DeconvolveBurnIn").getValueAsString(),inputs.get("DeconvolveIterations").getValueAsString(),kde);
        List<File> geneListFiles = makeGeneListFiles(uniDir,dataFiles.get(0),1000);
        String scriptFile = makeDeconvolveScript(geneListFiles);
        
        // start the expression script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();  

        inputs.get("DeconvolveSubmitted").setValue(new Date());
        inputs.get("DeconvolveCompleted").setValue(null);
    } 

    private List<File> makeGeneListFiles(File dir,File data,int nGenes)throws Exception {
        ArrayList<File> ret = new ArrayList<>();
        int fileNumber = 0;
        PrintStream stream=null;
        BufferedReader reader = new BufferedReader(new FileReader(data));
        String line = reader.readLine();  // skip the header
        line = reader.readLine();
        int i = Integer.MAX_VALUE;
        while (line != null){
            if (i > nGenes){
                if (stream != null) stream.close();
                File outfile = new File(dir,String.format("Genes.%d",fileNumber ));
                ret.add(outfile);
                stream = new PrintStream(outfile);
                ++fileNumber;
                i = 1;
            }
            String gene = line.split("\t")[0];
            stream.println(gene);
            ++i;
            line = reader.readLine();
        }
        reader.close();
        stream.close();
        return ret;
    }
    private String makeDeconvolveScript(List<File> geneListFiles)throws Exception {
        File scriptFile = GridSubmitOld.scriptFile(this.uniID,"Unification","Deconvolution");
        
         // build the script file for this deconvolution 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  

        for (File geneListFile : geneListFiles){
            File qsubFile = GridSubmitOld.qsubFile(this.uniID,String.format("Deconvolve%s",geneListFile.getName()));
        
            writer.printf("qsub -e %s -o %s %s\n", uniDir.getPath(),uniDir.getPath(),qsubFile.getPath());
            
            scriptFile.setReadable(true,false);
            scriptFile.setExecutable(true, false);
            scriptFile.setWritable(true, false);     

            // build the qsub file
            PrintWriter qsubwriter = new PrintWriter(qsubFile);
            qsubwriter.println("#$ -S /bin/bash");
            qsubwriter.println("#$ -l mfree=16G");
            qsubwriter.println("date"); 
            qsubwriter.printf("cd %s\n",uniDir.getPath());
            qsubwriter.printf("/nfs/waterston/celtdModel/jdk1.7.0/bin/java -jar -Xms4G /nfs/waterston/tools3/Unification.jar Deconvolution %s none %s ",geneListFile.getName(),uniDir.getPath()); 
            String[] tsList = getTimeSeries();
            for (String ts : tsList){
                qsubwriter.printf(" %s", ts);
            }
            qsubwriter.println();
//            qsubwriter.printf("chown -R :waterstonlab %s\n",uniDir.getPath());
//            qsubwriter.printf("chmod -R 770 %s\n",uniDir.getPath());
            qsubwriter.close();
        }
        writer.close();
        return scriptFile.getPath();
    }
    
    public void submit()throws Exception {
        uniID = inputs.get("UnificationID").getValueAsString();

        String dir = inputs.get("Directory").getValueAsString();
        uniDir = new File(dir);
        if (!uniDir.exists()) uniDir.mkdirs();
        FeatureGroup group = (FeatureGroup)((Features)inputs.get("Features")).getSelectedValue();
        buildBitSeqExpressionFiles(group);
        PrintStream outStream = new PrintStream(new File(uniDir,"TrainingConfig"));
        buildPMatixInitializationFile(outStream,inputs.get("BurnIn").getValueAsString(),inputs.get("Iterations").getValueAsString(),null);
        buildReportVariablesFile();   
        
        String scriptFile = makeScript();
        
        // start the expression script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();  

        inputs.get("Submitted").setValue(new Date());
        inputs.get("Completed").setValue(null);
    }    
    private String makeScript()throws Exception {
        File scriptFile = GridSubmitOld.scriptFile(this.uniID,"Unification","Training");
        File qsubFile = GridSubmitOld.qsubFile(this.uniID,"Unification");  
        
         // build the script file for this training 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  

        writer.printf("qsub -e %s -o %s %s\n", uniDir.getPath(),uniDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);     
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=16G");
        writer.println("date"); 
        writer.printf("cd %s\n",uniDir.getPath());
        writer.printf("/nfs/waterston/celtdModel/jdk1.7.0/bin/java -jar -Xms4G /net/waterston/vol2/home/gevirl/NetBeansProjects/Labmanagement/dist/Unification.jar  Training none none %s ",uniDir.getPath()); 
        String[] tsList = getTimeSeries();
        for (String ts : tsList){
            writer.printf(" %s", ts);
        }
        writer.println();
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.printf("/nfs/waterston/celtdModel/jdk1.7.0/bin/java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s Training \n",uniID); 
//        writer.printf("chown -R :waterstonlab %s\n",uniDir.getPath());
//        writer.printf("chmod -R 770 %s\n",uniDir.getPath());
        writer.close();        
        return scriptFile.getPath();
    }
  
    public String[] getTimeSeries(){
        JsonObject jsonObj = (JsonObject)this.getValue();
        String[] ret = new String[jsonObj.size()];
        int i=0;
        for (String tsID : jsonObj.keySet()){
            ret[i] = tsID;
            ++i;
        }
        return ret;
    }
    public String[] getExpressionIDs(String tsID){
        JsonObject jsonObj = (JsonObject)this.getValue();
        JsonArray repArray = (JsonArray)jsonObj.get(tsID);
        String[] ret = new String[repArray.size()];
        for (int i=0 ; i<ret.length ; ++i){
            ret[i] = repArray.getString(i);
        }
        return ret;
    } 
    public void buildReportVariablesFile() throws Exception {
        String ref = inputs.get("ReferenceTimeSeries").getValueAsString();
 
        PrintStream outStream = new PrintStream(new File(uniDir,"ReportVariables"));  
        
        String [] timeSeriesList = this.getTimeSeries();
        for (String timeSeries : timeSeriesList){
            if (!timeSeries.equals(ref)){
                outStream.println(PMatrix.getStartTimeVariableName(timeSeries));
                outStream.println(PMatrix.getGrowthRateVariableName(timeSeries));
            }
            outStream.println(PMatrix.getInitialVarianceVariableName(timeSeries));
//            outStream.println(PMatrix.getDispersionRateVariableName(timeSeries));
        }        
        outStream.close();
    }
    public void buildPMatixInitializationFile(PrintStream outStream,String burn,String iter,File file) throws Exception {
        String ref = inputs.get("ReferenceTimeSeries").getValueAsString();
        outStream.println("Name,Value");
        outStream.printf("Iterations,%s\n",iter);
        outStream.printf("BurnIn,%s\n",burn);
        outStream.printf("NStages,%s\n",inputs.get("Stages").getValueAsString());
        outStream.printf("%s,%s\n",PMatrixKdeFile.incName,inputs.get("StageIncrement").getValueAsString());
        outStream.printf("%s,%s\n",PMatrixKdeFile.startName,inputs.get("FirstStage").getValueAsString());
        int s1 = Integer.valueOf(inputs.get("SampleTime1").getValueAsString());
        int s2 = Integer.valueOf(inputs.get("SampleTime2").getValueAsString());
        int d1 = Integer.valueOf(inputs.get("DevelTime1").getValueAsString());
        int d2 = Integer.valueOf(inputs.get("DevelTime2").getValueAsString());
        double r = (double)(d2-d1)/(double)(s2-s1);
        double t0 = d1 - r*s1;
        outStream.printf("%s,%f\n", PMatrix.getStartTimeVariableName(ref),t0);
        outStream.printf("%s,%f\n", PMatrix.getGrowthRateVariableName(ref),r);
        if (file != null){
            KdeFile kde = new KdeFile();
            kde.setFile(file.getPath());
            String[] vars = kde.getVariables();
            for (String var : vars){
                Double val = kde.getValue(var, "Mode");
                outStream.printf("%s,%f\n", var,val);
            }
        }
        outStream.close();
    }
    public List<File> buildBitSeqExpressionFiles(FeatureGroup group)throws Exception {
        
        String [] timeSeriesList = this.getTimeSeries();
        ArrayList<File> ret = new ArrayList<>();
        
        for (String timeSeries : timeSeriesList){
            File outFile = new File(uniDir,timeSeries);
            ret.add(outFile);
            String [] expIDs = this.getExpressionIDs(timeSeries);
            buildBitSeqTimeSeriesFile(group,expIDs,outFile);
        }
        return ret;
    }
    static public void buildBitSeqTimeSeriesFile(FeatureGroup group,String [] expIDs,File outFile) throws Exception {
        exportTimeSeriesFile(group,expIDs,outFile,"\t");
    }
    static public void exportTimeSeriesFile(FeatureGroup group,String [] expIDs,File outFile,String sep) throws Exception {
            TreeMap<Integer,BufferedReader> readerMap = new TreeMap<>();
            
            // construct the file readers indexed by sample time
            for (int i=0 ; i<expIDs.length ; ++i){
                String expID = expIDs[i];
                String infile = ExpressionID.expressionFile(expID, group); 
                BufferedReader reader = new BufferedReader(new FileReader(infile));
                Integer time = ExpressionID.getSampleTime(expID);
                readerMap.put(time, reader);
            }
            
            // print the header (sample times) in the sorted order
            PrintStream outStream = new PrintStream(outFile);
            outStream.print("Feature");
            for (Integer time : readerMap.navigableKeySet()){
                outStream.printf("%s%d",sep, time);
            }
            outStream.println();
            
            // read all the input files and copy to the output file
            String[] lines = new String[expIDs.length];
            lines = readLines(lines,readerMap);
            while (lines != null){
                boolean first = true;
                for (int i=0 ; i<lines.length ; ++i){
                    String line = lines[i];
                    String[] tokens = line.split("\t| ");
                    if (first){
                        outStream.printf("%s\t%s",tokens[0],tokens[3]);
                        first = false;
                    } else {
                        outStream.printf("\t%s",tokens[3]);
                    }                    
                }
                outStream.println();
                lines = readLines(lines,readerMap);
            }
            
            // close all the files
            outStream.close();
            for (BufferedReader reader : readerMap.values()){
                reader.close();
            }        
    }
    // read the data in sample time order
    static private String[] readLines(String[] lines,TreeMap<Integer,BufferedReader> map)throws Exception {
        int i=0;
        for (Integer time : map.navigableKeySet()){
            BufferedReader reader = map.get(time);
            lines[i] = reader.readLine();
            
            if (lines[i] == null){
                return null;
            }
            ++i;
        }
        return lines;
    }
    String uniID;
    File uniDir;
    File warpDir;
}
