/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

/**
 *
 * @author gevirl
 */
public class GridSubmitOld {
    static public void startSubmission(String scriptFile)throws Exception {
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();          
    }
    static public void writeScriptFile(File scriptFile,File runningDirectory,File qsub)throws Exception{
         // build the script file for this alignment 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash"); 
        writer.printf("mkdir -p %s\n",runningDirectory.getPath());  //make the directory        
        writer.printf("qsub -e %s -o %s %s\n", runningDirectory.getPath(),runningDirectory.getPath(),qsub.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);
    }
    static public PrintWriter initializeQsub(File qsub,int gigs,int hours,String queue)throws Exception {
        qsub.createNewFile();
        qsub.setReadable(true,false);
        qsub.setExecutable(true, false);
        qsub.setWritable(true, false);        
        PrintWriter writer = new PrintWriter(qsub);
        writer.println("#$ -S /bin/bash");
        writer.println(String.format("#$ -l mfree=%dG",gigs));
        writer.println(String.format("#$ -l h_rt=%d:0:0",hours)); 
        if (!queue.equals("waterston")){
            writer.println(String.format("#$ -P %s",queue));
        }
        return writer;
    }
    static public void runClass(PrintWriter writer,String className,String[] args,int gig){
        writer.println("module load java/8u25");
        writer.printf("java -Xms%dG -classpath /nfs/waterston/tools3/LabManagement.jar %s ",gig, className);
        for (String arg : args){
            writer.printf("%s ", arg);
        }
        writer.println();
    }
    static public void runFinisher(PrintWriter writer,String program,String runID,int gig){
        writer.println("module load java/8u25");
        writer.printf("java  -jar -Xms%dG /nfs/waterston/tools3/RNASeqFinisher.jar %s %s\n",gig,runID,program);         
    }
    static public File scriptFile(String runID,String program,String version){
        File scriptDir = new File(baseDir,"scripts");
        File scriptFile = new File(scriptDir,runID+"_"+program+"_"+version+".sh");
        return scriptFile;
    }
    static public File qsubFile(String runID,String program){
        File qsubDir = new File(baseDir,"qsubs");
        File qsubFile = new File(qsubDir,runID+"_"+program+".qsub");
        return qsubFile;
    }
    // extract the program name from the qsub file name
    static String program(String qsub){
        String trimmed = qsub.substring(0, qsub.indexOf(".qsub"));
        return trimmed.substring(trimmed.lastIndexOf("_")+1);
    }
    // return the latest error file for each program run in the directory
    static public JsonObject latestErrorFiles(File runningDirectory){
        
        TreeMap<String,File> ret = new TreeMap<>();
        File[] files = runningDirectory.listFiles();
        if (files != null){
            for (File file : runningDirectory.listFiles()){
                String name = file.getName();
                if (name.contains(".qsub.e")){
                    String program = program(name);
                    File latest = ret.get(program);
                    if (latest == null){
                        ret.put(program,file);
                    } else {
                        if (latest.lastModified()<file.lastModified()){
                            ret.put(program,file);
                        }
                    }
                }
            }
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (String program : ret.keySet()){
            builder.add(program,ret.get(program).getPath());
        }
        return builder.build();
    }
    static String baseDir = "/nfs/waterston/LabMan";     
}
