/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class GeneFeatures {

    
    static private void loadFile(int i)throws Exception {
        TreeSet<String> genes = new TreeSet<>();
        BufferedReader reader = new BufferedReader(new FileReader(GeneFeatures.files[i]));
        String line = reader.readLine();
        while (line != null){
            genes.add(line);
            line = reader.readLine();
        }
        reader.close();
        sets.put(GeneFeatures.names[i], genes);
    }
    static public Set<String> getFeatureSet(String name){
        
        if (sets == null){
            sets = new TreeMap<>();
            for (int i=0 ; i< names.length ; ++i){
                try {
                    loadFile(i);
                }catch (Exception exc){
                    exc.printStackTrace();
                }
            }            
        }
        Set<String> ret = sets.get(name);
        return ret;
    }
    static public String[] getSetNames(){
        return names;
    }
    
    static  Map<String,Set<String>> sets;
    static public String[] names = {"All mRNA Genes","PolyA Genes(no histones)","All Steep Genes","PolyA Steep Genes(no histones"};
    static public String[] files = {"/net/waterston/vol9/References/WS245/AllGeneSet",
                            "/net/waterston/vol9/References/WS245/PolyaGeneSet",
                            "/net/waterston/vol9/References/WS245/AllSteepGeneSet",
                            "/net/waterston/vol9/References/WS245/PolyaSteepGeneSet"};

}
