/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.rhwlab.LMS.TextCell;

/**
 *
 * @author gevirl
 */
public class FastqArchiveFile extends TextCell {
    public FastqArchiveFile(){
        inputs.put("SequencingID",null);
        inputs.put("Directory", null);
    }

    public void update(){
        if (this.getValueAsString().equals("")){
            stateChanged(null);
        }
    }

    static String archiveFilename(String seqID,int pair,boolean dupsRemoved){
        if (dupsRemoved){
            return String.format("%s.nodups.pair%d.fastq.gz", seqID, pair);
        }
        return String.format("%s.pair%d.fastq.gz", seqID, pair);
    }
    public int readLength() throws Exception {
        String name = this.getValueAsString();
        FileInputStream inStream = new FileInputStream(name);
        GZIPInputStream gzStream = new GZIPInputStream(inStream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzStream));
        
        String line = reader.readLine();
        line = reader.readLine();
        if (line != null){
            return line.length();
        }
        return 0;
    }
}
