/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.rhwlab.LMS.TextCell;

/**
 *
 * @author gevirl
 */
public class ExpressionDirectory extends TextCell{
    public ExpressionDirectory(){
        inputs.put("UserName",null);
        inputs.put("DataSet",null);
        inputs.put("LibraryID",null);
        inputs.put("ExpressionID",null);
        inputs.put("Count", this);
        if (corr==null) corr = new SpearmansCorrelation();
    }
    public void stateChanged(ChangeEvent event){
        String dataset = inputs.get("DataSet").getValueAsString();
        if (dataset.equals(""))return;
        String user = inputs.get("UserName").getValueAsString();
        if (user.equals(""))return;
        String lib = inputs.get("LibraryID").getValueAsString();
        if (lib.equals("")) return;

        String count = inputs.get("Count").getValueAsString();
        if (count.equals("")) return;          
        
        this.setValue(String.format("/net/waterston/vol9/RNASeq/%s/%s/%s/Exp_%s", user,dataset,lib,count));
    } 
    public String getExpressionID(){
        return inputs.get("ExpressionID").getValueAsString();
    }
    public static Map<String,String[]> getExpressionValues(String dir,String expID,String[] transcripts)throws Exception {
        TreeMap<String,String[]> ret = new TreeMap<>();
        for (String transcript : transcripts){
            ret.put(transcript, null);
        }
        String fileName = String.format("%s.transcript.rpkm",expID);
        BufferedReader reader = new BufferedReader(new FileReader(new File(dir,fileName)));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(" ");
            if (ret.containsKey(tokens[0])){
                ret.put(tokens[0], tokens);
            }
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }
    static public double[][] autoSpearman(ExpressionDirectory[] dirs,String label)throws Exception {

        double[][] ret = new double[dirs.length][];
        for (int i=0 ; i<dirs.length ; ++i){
            double[] spears = dirs[i].spearman(dirs,label);
            ret[i] = spears;
        }
        
        return ret;
    }
    // compute the spearmean correlations between this directory expression data and a set of other expression directories
    public double[] spearman(ExpressionDirectory[] other,String label) throws Exception {
        
        Map<String,Double> data = this.readExpressionFile(label);
        double[] correlations = new double[other.length];
        for (int i=0 ; i<correlations.length ; ++i){
            Map<String,Double> otherData = other[i].readExpressionFile(label);
            // find feature name in common
            TreeSet<String> inCommon = new TreeSet<>();
            for (String key : data.keySet()){
                if (otherData.containsKey(key)){
                    inCommon.add(key);
                }
            }
            int j=0;
            double[] d1 = new double[inCommon.size()];
            double[] d2 = new double[inCommon.size()];
            for (String key : inCommon){
                d1[j] = data.get(key);
                d2[j] = otherData.get(key);
                ++j;
            }
            correlations[i] = corr.correlation(d1, d2);
        }
        return correlations;
    }
    // label identifies the feature group file(ie mRNA, genes, etc)
    public Map<String,Double> readExpressionFile(String label)throws Exception {
        TreeMap<String,Double> ret = new TreeMap<>();
        
        String dir = this.getValueAsString();
        String expID = this.getExpressionID();
        String file = String.format("%s/%s.%s.rpkm",dir,expID,label);
        
        BufferedReader reader = new BufferedReader (new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(" ");
            ret.put(tokens[0], new Double(tokens[3]));
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }

    static SpearmansCorrelation corr;

}
