/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.JsonCell;
import org.rhwlab.alignment.BAM;

/**
 *
 * @author gevirl
 */
public class Bams extends JsonCell{
    public Bams(){
        inputs.put("Directory", null);
        inputs.put("AlignmentIDs", null);
    }
    public void stateChanged(ChangeEvent event){
        determineBAMs();
    }
    
    // determine the bams for a set of alignment ids
    public JsonArray determineBAMs(){
        String expDir = inputs.get("Directory").getValueAsString();
        if (expDir.equals("")) {
            return null;
        }
        File libraryDir = new File(expDir).getParentFile();
        
//        String expressBy = inputs.get("ExpressionBy").getValueAsString();
        AlignmentIDs ids = (AlignmentIDs)inputs.get("AlignmentIDs");
        if (ids == null) {
            return null;
        }
        
        
        JsonArrayBuilder bamBuilder = Json.createArrayBuilder();
        String[] alignIDs = ids.getIDs();
        if (alignIDs[0].equals("")){
            return null;
        }
        for (String alignID : alignIDs){
            String[] tokens = alignID.split("_");
            File platformDir;
            File alignDir;
            if (tokens[tokens.length-1].equals("noDups")){
                platformDir = new File(libraryDir,String.format("%s_%s", tokens[2],tokens[tokens.length-2]));
                alignDir = new File(platformDir,String.format("%s_%s_nodups", tokens[0],tokens[1]));
            } else {
                platformDir = new File(libraryDir,String.format("%s_%s", tokens[2],tokens[tokens.length-1]));
                alignDir = new File(platformDir,String.format("%s_%s", tokens[0],tokens[1]));
            }
            
            File[] files = alignDir.listFiles();
            for (File file : files){
                if (file.getName().endsWith(".bam")){
                    bamBuilder.add(file.getPath()); 
                    
                }
            }
        }
        JsonArray ret = bamBuilder.build();
        this.setValue(ret);
        return ret;
        
    }  
/*    
    public void update(){
        JsonArrayBuilder builder = Json.createArrayBuilder();
        BAMs oldBAMs = (BAMs)inputs.get("BAMs");
        JsonArray oldValue = (JsonArray)oldBAMs.getValue();
        for (int i=0 ; i<oldValue.size() ; ++i){
            String val = oldValue.getString(i);
            if (!val.equals("")){
                int index = val.lastIndexOf('/')+1;

                String bam = String.format("%sWS245Xome_STAR2.4.2a/%s",val.substring(0,index),val.substring(index));
                builder.add(bam);
            }
        }
        this.setValue(builder.build());
        int asjdfhuis=0;        
    }
    */
    public String[] getBAMFiles(){
        if (this.getValue() instanceof JsonArray){
            JsonArray jsonArray = (JsonArray)this.getValue();
            String[] ret = new String[jsonArray.size()];
            for (int i=0 ; i<ret.length ; ++i){
                ret[i] = jsonArray.getString(i);
            }
            return ret;
        } else {
            String[] ret = new String[1];
            ret[0] = this.getValueAsString();
            return ret;
        }
    } 
    
    // merge and filter alignment BAM files
    // args[0] - if true, remove histones
    // args[1] - if true, remove rRNA
    // args[2] - output bam file
    // args[3] - species
    // args[4] and above - bam filenames to merge
    public static void main(String[] args)throws Exception{
        BAM[] bams = new BAM[args.length-4];
        for (int i=0 ; i<bams.length ; ++i){
            bams[i] = new BAM(new File(args[i+4]));
        }
        Set names = new TreeSet<>();
        if (args[0].equalsIgnoreCase("true")){
            names.addAll(BAM.getHistoneNames(args[3]));
        }
        if (args[1].equalsIgnoreCase("true")){
            names.addAll(BAM.getRibosomalNames(args[3]));
        }              
        BAM.filterMerge(bams,names,args[2]);
    }     
}
