/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.ListCell;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class AlignmentReference extends ListCell {
    public AlignmentReference()throws Exception {
        super();
        inputs.put("AlignSubmitted",null);
        inputs.put("ExpressionSubmitted",null);
        if (references == null){
            init();
        }
        
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.getValue();
        for (Reference ref : references){
            m.addElement(ref);
        }
        m.setSelectedItem(null);
    }
    @Override
    public boolean isEditable(){
        CellBase submitted= inputs.get("ExpressionSubmitted");
        if (submitted == null){
            submitted = inputs.get("AlignSubmitted");
            if (submitted == null){
                return false;
            }
        }
        return submitted.getValueAsString().equals("");
    }
    public void init()throws Exception {
        references = new ArrayList<>();
        String sql = "Select * from AlignmentReference where Display = 1 order by Species,Reference";
        ResultSet rs = MySql.getMySql().execute(sql);
        while(rs.next()){
            Reference ref = new Reference();
            ref.version = rs.getString("Version");
            ref.starIndex = rs.getString("STAR_index");
            ref.species = rs.getString("Species");
            ref.type = rs.getString("SequenceType");
            ref.seqFile = rs.getString("SequenceFile");
            ref.id = rs.getString("Reference");
            ref.program = rs.getString("Program");
            ref.readCounts = rs.getBoolean("ReadCounts");
            ref.GFF = rs.getString("GFF");
            ref.GTF = rs.getString("GTF");
            references.add(ref);
        }
    }
    static public Reference getReference(String refStr)throws Exception {
        Reference ref = new Reference();
        String sql = String.format("Select * from AlignmentReference where Reference = \'%s\'",refStr);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            ref.version = rs.getString("Version");
            ref.starIndex = rs.getString("STAR_index");
            ref.species = rs.getString("Species");
            ref.type = rs.getString("SequenceType");
            ref.seqFile = rs.getString("SequenceFile");
            ref.id = rs.getString("Reference");
            ref.program = rs.getString("Program");
            ref.readCounts = rs.getBoolean("ReadCounts");
            ref.GFF = rs.getString("GFF");
            ref.GTF = rs.getString("GTF");
        } 
        return ref;
    }
    static public String getSequenceFile(String ref)throws Exception {
        String sql = String.format("Select SequenceFile from AlignmentReference where Reference = \'%s\'",ref);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("SequenceFile");
        }
        return null;
    }
    static public String getVersion(String ref)throws Exception {
        String sql = String.format("Select Version from AlignmentReference where Reference = \'%s\'",ref);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("Version");
        }
        return null;
    } 
    public String getSpecies() throws Exception {
        Reference r = getSelectedReference();
        return r.species;         
    }
    public String getSequenceFile()throws Exception {
        Reference r = getSelectedReference();
        return r.seqFile;        
    }
    public String getGFF() throws Exception{
        Reference r = getSelectedReference();
        return r.GFF;          
    }
    public String getGTF() throws Exception{
        Reference r = getSelectedReference();
        return r.GTF;          
    }    
    public String getID()throws Exception {
        Reference r = getSelectedReference();
        return r.toString();
    }
    
    public String getSTARIndex()throws Exception {
        Reference r = getSelectedReference();
        return r.starIndex;
    }
    public boolean makeWIG()throws Exception {
        Reference r = getSelectedReference();
        return r.type.equals("Genome");
    }

    public String getType()throws Exception {
        Reference ref = getSelectedReference();
        return ref.type;

    }
    public String getProgram() throws Exception {
        Reference ref = getSelectedReference();
        return ref.program;
    }
    public boolean readCounts()throws Exception{
        Reference ref = getSelectedReference();
        return ref.readCounts;        
    }
    public Reference getSelectedReference()throws Exception {
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.getValue();
        Object obj = m.getSelectedItem();
        if (obj instanceof Reference){
            Reference r = (Reference)m.getSelectedItem();
            return r;
        }else {
            return getReference((String)obj);
        }        
    }
    public boolean validate(String newValue) {
        try {
            boolean ret = this.model.isRowUnique(this.getRow());
            if (ret == true) return true;
            String msg = String.format("%s already in database\nWill revert to previous value",this.getValueAsString());
            JOptionPane.showMessageDialog(LabMan.labMan, msg);
            return false;
        } catch (Exception exc){
            exc.printStackTrace();
            return true;
        }

    }
    static ArrayList<Reference> references;

}


