/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.RNASeq.md5.MD5sum;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class AlignmentID extends TextCell implements GridSubmittable  {
    static String[] alignDBNames = {"TotalAlignments","rRNAAlignments","mitoAlignments"};    
    public AlignmentID(){
        super();
        inputs.put("Reference",null);
        inputs.put("Aligner",null);
        inputs.put("SequencingID",null);
        inputs.put("DupsRemoved",null);
    }
    public boolean validate(String newValue) {
/*        
        try {
        if (checkUnique(newValue)){
            return true;
        }
        JOptionPane.showMessageDialog(panel, "Duplicate AlignmentID, possibly change the reference");
        
        } catch (Exception exc ){
            exc.printStackTrace();
        }
        return false;
*/
        return true;
    }
    static public String getSequencingID(String alignID)throws Exception {
        String sql = String.format("Select SequencingID from RNASeqIndividualAlign where AlignmentID = \'%s\'",alignID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("SequencingID");
        }
        else {
            return null;
        }
    }
    static public boolean finishedAligning(String alignID)throws Exception {
        String sql = String.format("Select AlignCompleted from RNASeqIndividualAlign where AlignmentID = \'%s\'",alignID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getDate("AlignCompleted") != null;
        }
        else {
            return false;
        }
    }    
    private boolean checkUnique(String newValue)throws Exception {
        String sql = String.format("Select AlignmentID from RNASeqIndividualAlign where AlignmentID = \'%s\'",newValue);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return false;
        }
        // check the current panel too
       
        int c = this.model.getConfig().getColumn("AlignmentID");
        int n = this.model.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == this.getRow()) continue;
            CellBase base = (CellBase)this.model.getValueAt(r,c);
            String cellVal = base.getValueAsString(); 
            if (cellVal.equals(newValue)){
                return false;
            }
        }
        return true;
    }
    public void stateChanged(ChangeEvent event){
        String ref = inputs.get("Reference").getValueAsString();
        if (ref.equals(""))return;
        String align = inputs.get("Aligner").getValueAsString();
        if (align.equals(""))return;
        String seqID = inputs.get("SequencingID").getValueAsString();
        if (seqID.equals("")) return;
        
        Boolean dupsRem = false;
        if (inputs.get("DupsRemoved") != null){
            dupsRem = (Boolean)inputs.get("DupsRemoved").getValue();
        }
        
        String newVal;
        if (!dupsRem){
            newVal = String.format("%s_%s_%s",ref,align, seqID);
        }else {
            newVal = String.format("%s_%s_%s_noDups",ref,align, seqID);
        }
        if (validate(newVal)){
            this.setValue(newVal);
        }else {
            setValue("");
        }
        
    }

    static public String getDirectory(String alignID) throws Exception {
        String sql = String.format("Select * from RNASeqIndividualAlign where AlignmentID = \'%s\'",alignID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            boolean dups = rs.getBoolean("DupsRemoved");
            String fName = String.format("%s_%s",rs.getString("Reference"),rs.getString("Aligner"));
            if (dups){
                fName = fName+"_nodups";
            }
            File file = new File(rs.getString("SequenceDirectory"),fName);
            return file.getPath();
        }
        return null;
    }
    static public String getSpecies(String alignID)throws Exception{
        String sql = String.format("Select * from RNASeqIndividualAlign where AlignmentID = \'%s\'",alignID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("Species");
        } 
        return null;
    }
    static public void updateAlignDates(String dir,String id)throws Exception {
        File alignDir = new File(dir);
        
        if (alignDir.exists()){
            String alignBam = hasBAM(alignDir);
            if (alignBam != null){
                File align = new File(alignDir,alignBam);
                java.sql.Timestamp sqlTime = new java.sql.Timestamp(align.lastModified());
                String sql = "Update RNASeqIndividualAlign set AlignCompleted = ? where AlignmentID = ?";
                PreparedStatement state = MySql.getMySql().getStatement(sql);
                state.setTimestamp(1, sqlTime);
                state.setString(2,id);
                state.execute();
            }
        }   
        
    }

    // find the first listed bam file
    static private String hasBAM(File dir){
        String[] files = dir.list();
        for (String file : files){
            if (file.endsWith(".bam")){
                return file;
            }
        }
        return null;
    }    
    
    // report the read counts for a set of alignments
    static public TreeMap<String,LinkedHashMap<String,Integer>> readReport(String[] alignIDs)throws Exception {
        TreeMap<String,LinkedHashMap<String,Integer>> ret = new TreeMap<>();
        for (String alignID : alignIDs){
            TreeMap<String,String> logReport = logReport(alignID);
            LinkedHashMap<String,Integer> readReport = new LinkedHashMap<>();
            int total = Integer.valueOf(logReport.get("Number of input reads"));
            readReport.put("Total Reads",total);
            int unique = Integer.valueOf(logReport.get("Uniquely mapped reads number"));
            readReport.put("Uniquely Mapped",unique);
            int multi = Integer.valueOf(logReport.get("Number of reads mapped to multiple loci"));
            readReport.put("Multi Mapped", multi);
            readReport.put("Unmapped", total - unique - multi);
            
            for (String alignDBName : alignDBNames){
                readReport.put(alignDBName,Integer.valueOf(logReport.get(alignDBName)));
            }
            ret.put(alignID,readReport);
        }
        return ret;
    } 
    
    static public int alignedReads(String alignID)throws Exception {
        TreeMap<String,String> logReport = AlignmentID.logReport(alignID);
        int uniqueReads = Integer.valueOf(logReport.get("Uniquely mapped reads number"));
        int multiReads = Integer.valueOf(logReport.get("Number of reads mapped to multiple loci"));  
        return uniqueReads + multiReads;
    }
    // report the contents of the logfile in a map for a given alignment
    static public TreeMap<String,String> logReport(String alignID) throws Exception {
        TreeMap<String,String> map = new TreeMap<>();
        String sql = String.format("Select * from RNASeqIndividualAlign where AlignmentID = \'%s\'",alignID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String logFile = rs.getString("LogFile");
            BufferedReader reader = new BufferedReader(new StringReader(logFile));
            String line = reader.readLine();
            while (line != null){
                String[] tokens = line.split("\\|");
                if (tokens.length == 2){
                    map.put(tokens[0].trim(),tokens[1].trim());
                }
                line = reader.readLine();
            }
            // add the alignments too
            for (String alignDBName : alignDBNames){
                map.put(alignDBName, rs.getString(alignDBName));
            }
        }
        return map;        
    }
    // find a BAM file for the given sequencingID and Reference and aligner
    static List<String> findBAMFiles(String seqID,String ref,String aligner) throws Exception{
        PreparedStatement state = MySql.getMySql().getStatement("Select MD5s from RNASeqIndividualAlign where SequencingID = ? and Reference = ? and Aligner = ?");
        state.setString(1, seqID);
        state.setString(2, ref);
        state.setString(3, aligner);
        state.execute();
        ResultSet rs = state.getResultSet();
        if (rs.next()){
            String md5s =  rs.getString("MD5s");
            MD5sum md5sum = new MD5sum();
            md5sum.setValue(md5s);
            return md5sum.getBAMFiles();
        }
        return null;
    }
    static public List<String> findGenomicAlignments(String seqID)throws Exception {
        ArrayList<String> ret = new ArrayList<>();
        PreparedStatement state = MySql.getMySql().getStatement("Select AlignmentID from RNASeqIndividualAlign where SequencingID = ? and Reference like ?");
        state.setString(1, seqID);
        state.setString(2, "%Genome%");   
        state.execute();
        ResultSet rs = state.getResultSet();
        while(rs.next()){
            ret.add(rs.getString("AlignmentID"));
        }
        return ret;
    }

    @Override
    public void submit(String program, int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

}
