 /*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class Aligning extends TextCell implements GridSubmittable {
    public Aligning(){

        inputs.put("SequenceArchive",null);
        inputs.put("SequencingID",null);  
        inputs.put("AlignmentID",null);
        inputs.put("Stranded",null);
        inputs.put("AlignSubmitted",null);
        inputs.put("AlignCompleted",null);
        inputs.put("Stranded", null);
        inputs.put("Species", null);
        inputs.put("Reference",null);
        inputs.put("Directory",null);
    }
    @Override
    public void submit(String program, int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        if (program.equals("Align")){
            submitAlign(program,cores,memory,hours,queue,arrayjob,concurrent);
        } if (program.equals("PostProcess")){
            submitPostProcess(program,cores,memory,hours,queue,arrayjob,concurrent);           
        }
    }
    public void submitPostProcess(String program,int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        inputs.get("AlignCompleted").setValue(null); 
        
        String dir = inputs.get("Directory").getValueAsString();
        File dirFile = new File(dir);
        String alignID = inputs.get("AlignmentID").getValueAsString();
        AlignReference alignRef = (AlignReference)inputs.get("Reference");
        
        GridSubmit gs = new GridSubmit(alignID,program,dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();        
        
        // run the finisher
        ArrayList<String> args = new ArrayList();
        args.add(alignID);
        args.add("STAR");
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.RNASeq.Finisher" , args);
        
        gs.run();        
    }    
    public void submitAlign(String program,int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        inputs.get("AlignSubmitted").setValue(new Date()); 
        inputs.get("AlignCompleted").setValue(null); 
        
        String dir = inputs.get("Directory").getValueAsString();
        File dirFile = new File(dir);
        String alignID = inputs.get("AlignmentID").getValueAsString();
        AlignReference alignRef = (AlignReference)inputs.get("Reference");
        
        GridSubmit gs = new GridSubmit(alignID,program,dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();
        
        // do the genomic alignment
        runAlign(true,qsubStream,alignRef,dirFile);
        qsubStream.println("for F in `ls -1 *.wig`");
        qsubStream.println("do");
        qsubStream.println("G=`echo $F | sed s/wig/bw/`");
        qsubStream.printf("/net/waterston/vol9/wigToBigWig `echo $F` %s/chrNameLength.txt  `echo $G` \n",alignRef.getGenomicIndex());
        qsubStream.println("rm -f $F ");
        qsubStream.println("done");      
        qsubStream.println("mv -f Log.out GenomeLog.out");
        qsubStream.println("mv -f Log.progress.out GenomeLog.progress.out");
        qsubStream.println("mv -f Log.final.out GenomeLog.final.out");
        
        // do the xome alignment
        runAlign(false,qsubStream,alignRef,dirFile);
        qsubStream.println("mv -f Log.out XomeLog.out");
        qsubStream.println("mv -f Log.progress.out XomeLog.progress.out");
        qsubStream.println("mv -f Log.final.out XomeLog.final.out");   
        qsubStream.println("rm -fr _STARtmp");
        qsubStream.println("mv -f Aligned.out.bam Aligned.toTranscriptome.out.bam");
        
        // run the finisher
        ArrayList<String> args = new ArrayList();
        args.add(alignID);
        args.add("STAR");
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.RNASeq.Finisher" , args);
        gs.run();
    }    
    private void runAlign(boolean genomic,PrintWriter writer,AlignReference reference,File workingDir){
        String seqID = inputs.get("SequencingID").getValueAsString();
        String seqDir = inputs.get("SequenceArchive").getValueAsString(); 
        
        writer.print(reference.getProgram());
        writer.print(" --runThreadN 4 ");   

        File fastq1 = new File(seqDir,Fastq1ArchiveFile.archiveFilename(seqID,1,false));
        File fastq2 = new File(seqDir,Fastq2ArchiveFile.archiveFilename(seqID,2,false));
        if (fastq2.exists()){
            writer.printf("--readFilesIn %s %s ",fastq1.getPath(),fastq2.getPath());
        }else {
            writer.printf("--readFilesIn %s ",fastq1.getPath());
        }   
        writer.printf("--outFileNamePrefix %s/  ",workingDir.getPath());
        writer.print("--outSAMreadID Standard  ");
        writer.print("--readFilesCommand zcat ");  
        
        if (genomic){
            writer.printf("--genomeDir %s ",reference.getGenomicIndex());
            if (inputs.get("Species").getValueAsString().equals("CElegans")){
                writer.print("--alignIntronMax 25000  ");
            }            
            writer.print("--outFilterMultimapNmax 100 --winAnchorMultimapNmax 100  --outSAMtype BAM SortedByCoordinate --outWigType wiggle  --alignSoftClipAtReferenceEnds No  --limitBAMsortRAM 6489940811  ");
            if (inputs.get("Stranded").getValueAsString().equals("1")){
                writer.print("--outWigStrand Stranded ");
            } else {
                writer.print("--outWigStrand Unstranded ");
            }            
        } else {
            writer.printf("--genomeDir %s ",reference.getXomicIndex());
            writer.print("--outSAMtype BAM Unsorted  ");
            writer.print("--alignIntronMax 1  --winAnchorMultimapNmax 100  --outFilterMultimapNmax 100 ");
            if (inputs.get("Species").getValueAsString().equals("CElegans")){
                writer.print("--genomeChrBinNbits 9 ");
            }              
        }
        writer.print("--outSAMattributes All   \n");
    }
    // submit the alignment job
    public void submit()throws Exception {

        String scriptFile = makeSTARScript();
        // start the alignment script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();             
        inputs.get("AlignSubmitted").setValue(new Date()); 
        inputs.get("AlignCompleted").setValue(null);            
    }
    private String makeSTARScript()throws Exception{
        String alignID = inputs.get("AlignmentID").getValueAsString();
        File scriptFile = GridSubmitOld.scriptFile(alignID,"STAR","Align");
        File qsubFile = GridSubmitOld.qsubFile(alignID,"STAR");
        CellBase base = inputs.get("DupsRemoved");
        Boolean dups = false;
        if (base != null){
            dups = (Boolean)base.getValue();
        }
                
         // build the script file for this alignment 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash"); 
        
        String seqDir = inputs.get("SequenceArchive").getValueAsString();
        AlignmentReference reference = (AlignmentReference)inputs.get("Reference");
        String aligner = this.getValueAsString();
        File workingDir;
        if (dups) {
            workingDir = new File(seqDir,String.format("%s_%s_nodups",reference.getID(),aligner));
        } else {
            workingDir = new File(seqDir,String.format("%s_%s",reference.getID(),aligner));
        }
        // empty the working directory, if it exists
        if (workingDir.exists()){
            File[] alignFiles = workingDir.listFiles();
            for (File f : alignFiles){
                if (f.getName().contains(".qsub.")){
                    writer.printf("rm -f %s\n",f.getPath());
                }
            }
            
        } else {
            writer.printf("mkdir -p %s\n",workingDir.getPath());  //make the alignment directory
        }
        writer.printf("qsub -e %s -o %s %s\n", workingDir.getPath(),workingDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.printf("#$ -l mfree=%dG\n",LabMan.gridMemory.get("Alignment"));
        writer.println("#$ -l h_rt=120:0:0");
        if (!LabMan.grid.equals("waterston")){
            writer.println(String.format("#$ -P %s",LabMan.grid));
        }
        writer.println("module load samtools/latest");
        writer.println("date"); 
/*
        // clean up any old files in the sequence archive directory from previous program version
        writer.printf("cd %s\n",seqDir);
        writer.println("rm -f *.bam");
        writer.println("rm -rf *STARtmp");
        writer.println("rm -rf WIG");
        writer.println("rm -rf PLUS");
 */       
        writer.printf("cd %s\n",workingDir.getPath());
        writer.println("echo \"Starting STAR\""); 
        writer.print(reference.getProgram());
        writer.print(" --runThreadN 4 ");
        String seqID = inputs.get("SequencingID").getValueAsString();

        File fastq1 = new File(seqDir,Fastq1ArchiveFile.archiveFilename(seqID,1,dups));
        File fastq2 = new File(seqDir,Fastq2ArchiveFile.archiveFilename(seqID,2,dups));
        if (fastq2.exists()){
            writer.printf("--readFilesIn %s %s ",fastq1.getPath(),fastq2.getPath());
        }else {
            writer.printf("--readFilesIn %s ",fastq1.getPath());
        }
        
        writer.printf("--outFileNamePrefix %s/  ",workingDir.getPath());
        writer.printf("--genomeDir %s ",reference.getSTARIndex());

        if (reference.getID().equals("Genome5.2")){
            writer.print(" --quantTranscriptomeBan Singleend ");
        }
        if (reference.makeWIG()){
            // doing a genomic alignment
            if (inputs.get("Species").getValueAsString().equals("CElegans")){
                writer.print("--alignIntronMax 25000  ");
            }            
            writer.print("--outFilterMultimapNmax 30  --outSAMtype BAM SortedByCoordinate --outWigType wiggle  --alignSoftClipAtReferenceEnds No  --limitBAMsortRAM 6489940811 --quantMode TranscriptomeSAM ");
            if (reference.readCounts()){
                writer.print("GeneCounts ");
            }
            if (inputs.get("Stranded").getValueAsString().equals("1")){
                writer.print("--outWigStrand Stranded ");
            } else {
                writer.print("--outWigStrand Unstranded ");
//                writer.print("--outSAMstrandField intronMotif ");                
            }
        }else {
            // doing a transcriptome alignment
            writer.print("--outSAMtype BAM Unsorted  ");
            writer.print("--alignIntronMax 1  --winAnchorMultimapNmax 100  --outFilterMultimapNmax 100 ");
            if (inputs.get("Species").getValueAsString().equals("CElegans")){
                writer.print("--genomeChrBinNbits 9 ");
            }  
        }

        writer.print("--outSAMreadID Standard  ");
        writer.print("--readFilesCommand zcat ");
//        writer.print("--genomeLoad NoSharedMemory --outSAMattributes All  --outReadsUnmapped Fastx \n");
//        writer.print("--outSAMattributes All  --outReadsUnmapped Fastx \n");
        writer.print("--outSAMattributes All   \n");
        
        // make the big wig files
        if (reference.makeWIG()){
            writer.println("for F in `ls -1 *.wig`");
            writer.println("do");
            writer.println("G=`echo $F | sed s/wig/bw/`");
            writer.printf("/net/waterston/vol9/wigToBigWig `echo $F` %s/chrNameLength.txt  `echo $G` \n",reference.getSTARIndex());
            writer.println("rm -f $F ");
            writer.println("done");
        }
/*
        // sort the xome bam
        File starBam = new File(workingDir,"Aligned.toTranscriptome.out.bam");
        File header = new File(workingDir,"header");
        writer.printf("echo $'@HD\\tVN:1.3  SO:queryname' > %s \n",header.getPath());
        writer.printf("samtools view -H %s >> %s\n", starBam.getPath(),header.getPath());
        writer.printf("samtools view %s | sort -T %s -k 1,1 -k 3,3 -k 4,4n >> %s \n",
                starBam.getPath(),workingDir.getPath(),header.getPath());
        writer.printf("samtools view -b %s > %s \n",header.getPath(),starBam.getPath() );
        writer.printf("rm -f %s\n", header.getPath());
*/         
        writer.println("date");
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.println("module load java/8u25");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s STAR \n",alignID); 
//        writer.printf("/nfs/waterston/celtdModel/jdk1.7.0/bin/java  -jar -Xms2G /net/waterston/vol2/home/gevirl/NetBeansProjects/Labmanagement/dist/RNASeqFinisher.jar %s STAR \n",alignID); 
//        writer.printf("chown -R  :waterstonlab %s\n",workingDir.getPath());
//        writer.printf("chmod 770 -R %s \n",workingDir.getPath());
        File starTmp = new File(workingDir,"_STARtmp");
        writer.printf("rm -rf %s\n",starTmp.getPath());
        writer.close(); 
        qsubFile.setReadable(true,false);
        qsubFile.setExecutable(true, false);
        qsubFile.setWritable(true, false);
        
        return scriptFile.getPath();
    }

    public boolean validate(String newValue)  {
        return true;
    } 



}
