/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import javax.swing.DefaultComboBoxModel;
import org.rhwlab.LMS.ListCell;

/**
 *
 * @author gevirl
 */
public class AlignReference extends ListCell {
    static Reference flyRef=null;
    static Reference wormRef=null;
    static Reference sciRef = null;
    
    public AlignReference(){
        super();
        if (wormRef == null){
            init();
        }
        DefaultComboBoxModel boxModel = (DefaultComboBoxModel)value;
        boxModel.addElement(wormRef);
        boxModel.addElement(flyRef);
        boxModel.addElement(sciRef);
        boxModel.setSelectedItem(null);
    }
    public String getProgram(){
        String ret = null;
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)value;
        Reference ref = (Reference)boxmodel.getSelectedItem();
        if (ref != null){
            ret = ref.program;
        }
        return ret;
    }
    public String getGenomicIndex(){
        String ret = null;
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)value;
        Reference ref = (Reference)boxmodel.getSelectedItem();
        if (ref != null){
            ret = ref.genomeStarIndex;
        }
        return ret;        
    }
    public String getXomicIndex(){
        String ret = null;
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)value;
        Reference ref = (Reference)boxmodel.getSelectedItem();
        if (ref != null){
            ret = ref.xomeStarIndex;
        }
        return ret;        
    }
    public String getXomicSequence(){
        String ret = null;
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)value;
        Reference ref = (Reference)boxmodel.getSelectedItem();
        if (ref != null){
            ret = ref.xomeSeqFile;
        }
        return ret;        
    } 
    public String getBitSeqXome(){
        String ret = null;
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)value;
        Reference ref = (Reference)boxmodel.getSelectedItem();
        if (ref != null){
            ret = ref.bitSeqXome;
        }
        return ret;             
    }
    public String getHTSeqGFF(){
        String ret = null;
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)value;
        Reference ref = (Reference)boxmodel.getSelectedItem();
        if (ref != null){
            ret = ref.HTSeqGFF;
        }
        return ret;             
    }    
    public String getHTSeqGTF(){
        String ret = null;
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)value;
        Reference ref = (Reference)boxmodel.getSelectedItem();
        if (ref != null){
            ret = ref.HTSeqGTF;
        }
        return ret;             
    }      
    @Override
    public boolean validate(String newValue) {
        return true;
    }

    private void init(){
        flyRef = new Reference();        
        flyRef.release = "Release6Genome";
        flyRef.species = "Dmel";
        flyRef.genomeSeqFile = "/net/waterston/vol9/References/Release6/dmel-all-chromosome-r6.15.fasta";
        flyRef.xomeSeqFile = "/net/waterston/vol9/References/Release6/dmel-all-chromosome-r6.15.xome.fasta";
        flyRef.genomeStarIndex = "/net/waterston/vol9/STAR_Indexes/Release6/Genome";
        flyRef.xomeStarIndex = "/net/waterston/vol9/STAR_Indexes/Release6/Transcriptome";
        flyRef.program = "/net/waterston/vol9/STAR-STAR_2.4.2a/bin/Linux_x86_64/STAR";
        flyRef.StarindexGFF = "/net/waterston/vol9/References/Release6/dmel-all-r6.15.gtf";
        flyRef.HTSeqGFF = "/net/waterston/vol9/References/Release6/dmel-all-r6.04.bdgp.gtf";
        flyRef.XomeGff = null;
        
        wormRef = new Reference();
        wormRef.release = "WS245Genome";
        wormRef.species = "CElegans";
        wormRef.genomeSeqFile = "/net/waterston/vol9/References/WS245/c_elegans.PRJNA13758.WS245.genomic.renamed.fa";
        wormRef.xomeSeqFile = "/net/waterston/vol9/References/WS245/WS245TranscriptomeFromGFF.fasta";
        wormRef.genomeStarIndex = "/net/waterston/vol9/STAR_Indexes/WS245/Genome";
        wormRef.xomeStarIndex = "/net/waterston/vol9/STAR_Indexes/WS245/TranscriptomeFromGFF";
        wormRef.program = "/net/waterston/vol9/STAR-STAR_2.4.2a/bin/Linux_x86_64/STAR";
        wormRef.StarindexGFF = "/net/waterston/vol9/References/WS245/WS245.exons.sort.renamed.gff3";  // star index built with this
        wormRef.HTSeqGFF = "/net/waterston/vol9/References/WS245/WormBase.gene.renamed.gff3";   // htseq count run using
        wormRef.XomeGff = "/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3";  // bitseq xome built with this (all annotations with WormBase or WormBase_transposon in column 2)
        wormRef.bitSeqXome = "/net/waterston/vol9/References/WS245/mRNA.pseudo.xome.fa"; // includes exons from mRNA,transposons, and pseudogenes
        wormRef.HTSeqGTF = "/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gtf";
        
        sciRef = new Reference();
        sciRef.release = "WS253Genome";
        sciRef.species = "CElegans";
        sciRef.genomeSeqFile = "/net/waterston/vol9/SingleCell/WS253/c_elegans.PRJNA13758.WS253.genomic.fa";
        sciRef.genomeStarIndex = "/net/waterston/vol9/SingleCell/WS253/STAR_index";
        sciRef.program = "/net/waterston/vol9/STAR-STAR_2.4.2a/bin/Linux_x86_64/STAR";
        sciRef.HTSeqGFF = "/net/waterston/vol9/SingleCell/WS253/c_elegans.PRJNA13758.WS253.canonical_geneset.gtf";
    }
    static class Reference {
        String release;
        String species;
        String genomeSeqFile;
        String xomeSeqFile;
        String genomeStarIndex;
        String xomeStarIndex;
        String program;
        String StarindexGFF;
        String HTSeqGFF;
        String XomeGff;
        String bitSeqXome;
        String HTSeqGTF;
        @Override
        public String toString(){
            return release;
        }
    }
}
