/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
// the value of this cell is a controlled vocabulary
// user selects from a list
abstract public class ListCell extends CellBase {
    public ListCell(){
        this(new DefaultComboBoxModel());
    }
    public ListCell(DefaultComboBoxModel obj){
        super(obj);
    }
    public boolean setValue(Object newValue){
        return this.setValue(newValue, true);
    }
    public boolean setValue(Object obj,boolean notify){
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)this.value;
        if (obj instanceof String){
            String newValue = ((String)obj).trim();

            Object selected = null;
            for (int i=0 ; i<boxmodel.getSize() ; ++i){
                Object element = boxmodel.getElementAt(i);
                if (element.toString().equals(newValue)){
                    selected = element;
                    break;
                }
            }
            if (this.model == null){
                int szjfs=0;
            }
            if (selected != null){
                boxmodel.setSelectedItem(selected);  // found the new value in the list
            }else if (this.model.isLoading()){
                boxmodel.addElement(newValue);       // model is loading so set the value
                boxmodel.setSelectedItem(newValue);
            }else {
                boxmodel.setSelectedItem(null);  // don't set the value if it is not in the list
            }
            return super.setValue(boxmodel,notify);  // trigger notification of listeners
        }
        if (obj instanceof DefaultComboBoxModel)
            return super.setValue(obj,notify);
        else {
            boxmodel.setSelectedItem(null);
            return super.setValue(boxmodel,notify); 
        }
        
        
    }    
    @Override
    public String getValueAsString() {
        DefaultComboBoxModel box = (DefaultComboBoxModel)value;
        if (box == null) {
            return "";
        }
        Object sel = box.getSelectedItem();
        if (sel == null){
            return "";
        } else {
            return sel.toString().trim();
        }            
    }
    public Object getSelectedValue(){
        DefaultComboBoxModel box = (DefaultComboBoxModel)value;
        return box.getSelectedItem();
    }
    @Override
    public int compareTo(Object o) {
        ListCell other = (ListCell)o;
        String v = this.getValueAsString();
        int ret = this.getValueAsString().compareTo(other.getValueAsString());
        return ret;
    }
    
}
