/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.io.File;
import java.util.ArrayList;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class FileListCell extends CellBase{
    public FileListCell(){
        super(new File[0]);
    }
    @Override
    public boolean validate(String newValue) {
        return true;
    }
    public boolean setValue(Object newValue){
        return this.setValue(newValue, true);
    }
    public boolean setValue(Object obj,boolean notify){
        File[] files = new File[0];
        if (obj instanceof String){
            str = (String)obj;
            String[] tokens = str.split(","); 
            files = new File[tokens.length];
            for (int i=0 ; i<tokens.length ; ++i){
                files[i] = new File(tokens[i]);
            }
        }else if (obj instanceof File[]){
            str = null;
            files = (File[])obj;
        }

        return super.setValue(files,notify);
    }
    @Override
    public String getValueAsString() {
        if (str != null) return str;
        File[] files = (File[])this.getValue();
        if (files.length==0) return "";
        
        StringBuilder builder = new StringBuilder(files[0].getPath());
        for (int i=1 ; i<files.length ; ++i){
            builder.append(',');
            builder.append(files[i].getPath());
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Object o) {
        String other = ((FileListCell)o).getValueAsString();
        return this.getValueAsString().compareTo(other);
    }
    String str;
}
