/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.FACS;

import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.dataframe.FACSSamples;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class SampleNameRemap extends TextCell {

    public SampleNameRemap() {
        super();
    }

    public void stateChanged(ChangeEvent event) {
        CellBase base = (CellBase) event.getSource();

        String original = base.getValueAsString();
        String remapped =  remap(original);
        if (remapped != null){
            this.setValue(remapped);
        }

    }
    
    // remap a sample id to consistent naming
    public static String remap(String original){
        int i = original.indexOf("T");
        if (i > 0) {
            String name = original.substring(0, i);

            String alias = nameMap.get(name);
            if (alias != null) {
                try {
                    int time = Integer.valueOf(original.substring(i + 1,i + 2));
                    String remapName = String.format("%srep%dT%d", alias, repMap.get(name), time);
                    remapName = remapName.replace("nhr25end1", "nhr25");
                    return remapName;
                } catch (Exception exc) {
                }
            }
        } 
        return null;
    }
    static final TreeMap<String, Integer> repMap = new TreeMap<>();
    static final TreeMap<String, String> nameMap = new TreeMap<>();

    static {
        nameMap.put("ceh32rep", "ceh32");
        nameMap.put("ceh32rep2", "ceh32");
        nameMap.put("nonceh32rep", "nonceh32");
        nameMap.put("nonceh32rep2", "nonceh32");
        nameMap.put("cnd1", "cnd1");
        nameMap.put("cnd1rep", "cnd1");
        nameMap.put("noncnd1", "noncnd1");
        nameMap.put("noncnd1rep", "noncnd1");
        nameMap.put("end1", "end1");
        nameMap.put("end1rep", "end1");
        nameMap.put("hlh1", "hlh1");
        nameMap.put("hlh1rep2", "hlh1");
        nameMap.put("hlh1rep3", "hlh1");
        nameMap.put("hlh1rep4", "hlh1");
        nameMap.put("nonhlh1", "nonhlh1");
        nameMap.put("nonhlh1rep2", "nonhlh1");
        nameMap.put("nhr25end1", "nhr25end1");
        nameMap.put("nhr25end1rep", "nhr25end1");
        nameMap.put("nonnhr25end1", "nonnhr25end1");
        nameMap.put("nonnhr25end1rep", "nonnhr25end1");
        nameMap.put("pha4", "pha4");
        nameMap.put("pha4rep", "pha4");
        nameMap.put("tbx37rep", "tbx37");
        nameMap.put("tbx37rep3", "tbx37");
        nameMap.put("tbx37rep4", "tbx37");
        nameMap.put("nontbx37rep", "nontbx37");
        nameMap.put("nontbx37rep2", "nontbx37");

        repMap.put("ceh32rep", 1);
        repMap.put("ceh32rep2", 2);
        repMap.put("nonceh32rep", 1);
        repMap.put("nonceh32rep2", 2);
        repMap.put("cnd1", 1);
        repMap.put("cnd1rep", 2);
        repMap.put("end1", 1);
        repMap.put("end1rep", 2);
        repMap.put("hlh1", 1);
        repMap.put("hlh1rep2", 2);
        repMap.put("hlh1rep3", 3);
        repMap.put("hlh1rep4", 4);
        repMap.put("nonhlh1", 1);
        repMap.put("nonhlh1rep2", 2);
        repMap.put("nhr25end1", 1);
        repMap.put("nhr25end1rep", 2);
        repMap.put("nonnhr25end1", 1);
        repMap.put("nonnhr25end1rep", 2);
        repMap.put("pha4", 1);
        repMap.put("pha4rep", 2);
        repMap.put("tbx37rep", 1);
        repMap.put("tbx37rep3", 2);
        repMap.put("tbx37rep4", 3);
        repMap.put("nontbx37rep", 1);
        repMap.put("nontbx37rep2", 2);
    }
}
