/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.FACS;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 *
 * @author gevirl
 */
public class SRA_Headers {
    ArrayList<String> headers = new ArrayList<>();
    HashMap<String,String> defaults = new HashMap<>();
  
    public SRA_Headers()throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/rhwlab/LMS/FACS/SRA_Headers")));
        String line = reader.readLine();
        while (line !=null)        {
            String[] tokens = line.split(",");
            String head = tokens[0].trim();
            headers.add(head);
            if (tokens.length > 1){
                defaults.put(head,tokens[1].trim());
            }
            line = reader.readLine();
        }
        reader.close();          
    }
    public List<String> getHeaders(){
        return headers;
    }
    public String getDefault(String head){
        return defaults.get(head);
    }
    public void report(PrintStream stream){
        stream.print(headers.get(0));
        for (int i=1 ; i<headers.size() ; ++i){
            stream.printf("\t%s", headers.get(i));
        }
        stream.println();
    }
}
