/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.FACS;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.rhwlab.grid.GridSubmit;

/**
 *
 * @author gevirl
 */
public class SRA {

    public void formMetadataFile(String[] sampleIDs, File outDir) throws Exception {
        PrintStream stream = new PrintStream(new File(outDir, "SRA_Metadata.tsv"));

        ArrayList<String> remappedList = new ArrayList<>();
        for (String sampleID : sampleIDs) {
            remappedList.add(SampleNameRemap.remap(sampleID));
        }
        remappedList.sort(null);

        // read the headers
        SRA_Headers headers = new SRA_Headers();
        headers.report(stream);

        BioSampleObjects bsObjs = new BioSampleObjects();
        for (String remapped : remappedList) {

            String accession = bsObjs.getAccession(remapped);

            // write the output line
            boolean first = true;
            for (String header : headers.getHeaders()) {
                String val = headers.getDefault(header);
                if (val == null) {
                    if (header.equals("biosample_accession")) {
                        val = accession;
                    } else if (header.equals("library_ID")) {
                        val = remapped;
                    } else if (header.equals("filename")) {
                        val = remapped + ".bam";
                    }

                }
                if (header.equals("design_description")) {
                    if (remapped.contains("hlh1rep1")) {
                        val = val + "   includes reads from Illumina HiSeq";
                    }
                }
                if (first) {
                    stream.print(val);
                    first = false;
                } else {
                    stream.printf("\t%s", val);
                }
            }
            stream.println();
        }
        stream.close();

    }

    public void formQsubs(String[] dirs, String[] ids, File outDir) throws Exception {
        for (int i = 0; i < dirs.length; ++i) {
            String remapped = SampleNameRemap.remap(ids[i]);
            File inBam = new File(dirs[i], "Aligned.toGenome.out.bam");
            File outBam = new File(outDir, remapped + ".bam");
            GridSubmit submit = new GridSubmit(remapped, "sra", outDir);
            submit.setMemory(4);
            submit.setSlots(4);
            submit.setQueue("waterston");
            PrintWriter writer = submit.initializeQsub();
            writer.println("module load samtools/latest");
            writer.printf("samtools sort -@ 4  -O BAM -o %s  %s\n", outBam.getPath(), inBam.getPath());
            writer.flush();
            writer.close();
            submit.writeScriptFile();
            int ucccsdfui = 0;
        }
    }

    public static void main(String[] args) throws Exception {
        File outDir = new File("/net/waterston/vol2/home/gevirl/FACS");
        SRA sra = new SRA();
        sra.formMetadataFile(sampleIDs, outDir);
//        sra.formQsubs(dirs, sampleIDs, new File("/net/waterston/vol9/SRA"));
    }
    static String[] sampleIDs
            = {"ceh32rep2T0_1",
                "ceh32rep2T1_1",
                "ceh32rep2T2_1",
                "ceh32rep2T3_1",
                "ceh32rep2T4_1",
                "ceh32repT0_1",
                "ceh32repT1_1",
                "ceh32repT2_1",
                "ceh32repT3_1",
                "ceh32repT4_1",
                "cnd1repT0_1",
                "cnd1repT1_1",
                "cnd1repT2_1",
                "cnd1repT3_1",
                "cnd1repT4_1",
                "cnd1T0_1",
                "cnd1T1_1",
                "cnd1T2_1",
                "cnd1T3_1",
                "cnd1T4_1",
                "end1repT0_1",
                "end1repT1_1",
                "end1repT2_1",
                "end1repT3_1",
                "end1repT4_1",
                "end1T0_1",
                "end1T1_1",
                "end1T2_1",
                "end1T3_1",
                "end1T4_1",
                "hlh1rep2T0_1",
                "hlh1rep2T1_1",
                "hlh1rep2T2_1",
                "hlh1rep2T3_1",
                "hlh1rep2T4_1",
                "hlh1rep3T0_1",
                "hlh1rep3T1_1",
                "hlh1rep3T2_1",
                "hlh1rep3T3_1",
                "hlh1rep3T4_1",
                "hlh1rep4T0_1",
                "hlh1rep4T1_1",
                "hlh1rep4T2_1",
                "hlh1rep4T3_1",
                "hlh1rep4T4_1",
                "hlh1T0_1",
                "hlh1T1_1",
                "hlh1T2_1",
                "hlh1T3_1",
                "hlh1T4_1",
                "nhr25end1repT0_1",
                "nhr25end1repT1_1",
                "nhr25end1repT2_1",
                "nhr25end1repT3_1",
                "nhr25end1repT4_1",
                "nhr25end1T0_1",
                "nhr25end1T1_1",
                "nhr25end1T2_1",
                "nhr25end1T3_1",
                "nhr25end1T4_1",
                "pha4repT0_1",
                "pha4repT1_1",
                "pha4repT2_1",
                "pha4repT3_1",
                "pha4repT4_1",
                "pha4T0_1",
                "pha4T1_1",
                "pha4T2_1",
                "pha4T3_1",
                "pha4T4_1",
                "tbx37rep3T0_1",
                "tbx37rep3T1_1",
                "tbx37rep3T2_1",
                "tbx37rep3T3_1",
                "tbx37rep3T4_1",
                "tbx37rep4T0_1",
                "tbx37rep4T1_1",
                "tbx37rep4T2_1",
                "tbx37rep4T3_1",
                "tbx37rep4T4_1",
                "tbx37repT0_1",
                "tbx37repT1_1",
                "tbx37repT2_1",
                "tbx37repT3_1",
                "tbx37repT4_1"};
    static String[] dirs
            = {"/net/waterston/vol9/RNASeq/adwarner/ceh32rep2_DS1/ceh32rep2T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep2_DS1/ceh32rep2T1_1_1/Merged_2",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep2_DS1/ceh32rep2T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep2_DS1/ceh32rep2T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep2_DS1/ceh32rep2T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep_DS1/ceh32repT0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep_DS1/ceh32repT1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep_DS1/ceh32repT2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep_DS1/ceh32repT3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/ceh32rep_DS1/ceh32repT4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1rep_DS1/cnd1repT0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1rep_DS1/cnd1repT1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1rep_DS1/cnd1repT2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1rep_DS1/cnd1repT3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1rep_DS1/cnd1repT4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1_DS1/cnd1T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1_DS1/cnd1T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1_DS1/cnd1T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1_DS1/cnd1T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/cnd1_DS1/cnd1T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/end1rep_DS1/end1repT0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/end1rep_DS1/end1repT1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/end1rep_DS1/end1repT2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/end1rep_DS1/end1repT3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/end1rep_DS1/end1repT4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/Intestinal_DS1/end1T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/Intestinal_DS1/end1T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/Intestinal_DS1/end1T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/Intestinal_DS1/end1T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/Intestinal_DS1/end1T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep2_DS1/hlh1rep2T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep2_DS1/hlh1rep2T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep2_DS1/hlh1rep2T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep2_DS1/hlh1rep2T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep2_DS1/hlh1rep2T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep3_DS1/hlh1rep3T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep3_DS1/hlh1rep3T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep3_DS1/hlh1rep3T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep3_DS1/hlh1rep3T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep3_DS1/hlh1rep3T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep4_DS1/hlh1rep4T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep4_DS1/hlh1rep4T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep4_DS1/hlh1rep4T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep4_DS1/hlh1rep4T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1rep4_DS1/hlh1rep4T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1original_DS1/hlh1T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1original_DS1/hlh1T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1original_DS1/hlh1T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1original_DS1/hlh1T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/hlh1original_DS1/hlh1T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1rep_DS1/nhr25end1repT0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1rep_DS1/nhr25end1repT1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1rep_DS1/nhr25end1repT2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1rep_DS1/nhr25end1repT3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1rep_DS1/nhr25end1repT4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1Original_DS1/nhr25end1T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1Original_DS1/nhr25end1T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1Original_DS1/nhr25end1T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1Original_DS1/nhr25end1T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/nhr25end1Original_DS1/nhr25end1T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pha4rep_DS1/pha4repT0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pha4rep_DS1/pha4repT1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pha4rep_DS1/pha4repT2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pha4rep_DS1/pha4repT3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pha4rep_DS1/pha4repT4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pharyngeal_DS1/pha4T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pharyngeal_DS1/pha4T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pharyngeal_DS1/pha4T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pharyngeal_DS1/pha4T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/pharyngeal_DS1/pha4T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep3_DS1/tbx37rep3T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep3_DS1/tbx37rep3T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep3_DS1/tbx37rep3T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep3_DS1/tbx37rep3T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep3_DS1/tbx37rep3T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep4_DS1/tbx37rep4T0_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep4_DS1/tbx37rep4T1_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep4_DS1/tbx37rep4T2_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep4_DS1/tbx37rep4T3_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep4_DS1/tbx37rep4T4_1_1/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep_DS1/tbx37repT0_1_2/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep_DS1/tbx37repT1_1_2/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep_DS1/tbx37repT2_1_2/Merged_3",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep_DS1/tbx37repT3_1_2/Merged_1",
                "/net/waterston/vol9/RNASeq/adwarner/tbx37rep_DS1/tbx37repT4_1_2/Merged_1"};
}
