/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
abstract public class EditListCell extends CellBase {
    public EditListCell(){
        this(new DefaultComboBoxModel());
    }
    public EditListCell(DefaultComboBoxModel obj){
        super(obj);
    }
    public boolean setValue(Object newValue){
        return this.setValue(newValue, true);
    }
    public boolean setValue(Object obj,boolean notify){
        
        String newValue = "";
        if (obj != null){
            newValue = ((String)obj).trim();
        }
        DefaultComboBoxModel boxmodel = (DefaultComboBoxModel)this.value;
        int index = boxmodel.getIndexOf(newValue);
        if (index != -1 || this.model.isLoading()){
           
            boxmodel.setSelectedItem(newValue);
        }else {
             boxmodel.addElement(newValue);
            boxmodel.setSelectedItem(newValue);
        }
        return super.setValue(boxmodel,notify);
    }    
    @Override
    public String getValueAsString() {
        DefaultComboBoxModel box = (DefaultComboBoxModel)value;
        Object sel = box.getSelectedItem();
        if (sel == null){
            return "";
        } else {
            return ((String)sel).trim();
        }            
    }
    @Override
    public int compareTo(Object o) {
        EditListCell other = (EditListCell)o;
        String v = this.getValueAsString();
        int ret = this.getValueAsString().compareTo(other.getValueAsString());
        return ret;
    }
    
}
