/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.rhwlab.json.PrettyWriter;

/**
 *
 * @author gevirl
 */
public class DCCResponse extends TextCell{
    public boolean setValue(Object obj,boolean notify){
        
        boolean ret = super.setValue(obj, notify);
        init();
        ret = super.setValue(obj, notify);
        return ret;
    }
    public void init(){
        prettyList = new ArrayList<>(); 
        BufferedReader bufReader = new BufferedReader(new StringReader(this.getValueAsString()));
        try {
            String line = bufReader.readLine();
            while (line != null){
                PrettyWriter pretty = new PrettyWriter();
                pretty.write(line);
                prettyList.add(pretty);
                line = bufReader.readLine();
            }
        } catch (Exception exc){
            exc.printStackTrace();
        }        
    }
    public JsonObject getJsonForAccession(String accession){
        if (prettyList == null) init();
        for (PrettyWriter pretty : prettyList){
            JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
            for (int i=0 ; i<graphArray.size() ; ++i){
                JsonObject respObject = graphArray.getJsonObject(i);
                String acc = respObject.getString("accession");
                if (acc.equals(accession)){
                    return respObject;
                }
            }
        }
        return null;
    }
    // gets the first accession in the json
    public String getAccession(String jsonType){
        if (this.getValueAsString().equals("")){
            return "";
        }
        if (prettyList == null) init();
        for (PrettyWriter pretty : prettyList){
            String acc = getAccession(jsonType,pretty);
            if (!acc.equals("")){
                return acc;
            }
        }
        return "";
    }  

    public String getUuid(String jsonType){
        if (this.getValueAsString().equals("")){
            return "";
        }        
        if (prettyList == null) init();
        for (PrettyWriter pretty : prettyList){
            String acc = getUuid(jsonType,pretty);
            if (!acc.equals("")){
                return acc;
            }
        }
        return "";
    }
    public String getAccession(String jsonType,PrettyWriter pretty){
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i=0 ; i<graphArray.size() ; ++i){
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j=0 ; j<typeArray.size() ; ++j){
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (type.equalsIgnoreCase(jsonType)){
                    JsonString jsonString = respObject.getJsonString("accession");
                    if (jsonString==null){
                        return "";
                    }
                    return jsonString.getString();
                }
            }
        }
        return "";

    }
    public String getPairedEnd(PrettyWriter pretty){
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i=0 ; i<graphArray.size() ; ++i){
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j=0 ; j<typeArray.size() ; ++j){
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (type.equalsIgnoreCase("file")){
                    return respObject.getJsonString("paired_end").getString();

                }
            }
        }
        return null;

    }    
    public String getUuid(String jsonType,PrettyWriter pretty){
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i=0 ; i<graphArray.size() ; ++i){
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j=0 ; j<typeArray.size() ; ++j){
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (type.equalsIgnoreCase(jsonType)){
                    JsonString jsonString = respObject.getJsonString("uuid");
                    return jsonString.getString();
                }
            }
        }
        return "";
    }  
    static public String getUuid(JsonObject json,String jsonType){
        JsonArray graphArray = json.getJsonArray("@graph");
        for (int i=0 ; i<graphArray.size() ; ++i){
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j=0 ; j<typeArray.size() ; ++j){
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (type.equalsIgnoreCase(jsonType)){
                    JsonString jsonString = respObject.getJsonString("uuid");
                    return jsonString.getString();
                }
            }
        }
        return "";        
    }
    public List<String> getAccessions(String jsonType){
        if (prettyList == null) init();
        ArrayList<String> ret = new ArrayList<>();
        for (PrettyWriter pretty : prettyList){
            String acc = getAccession(jsonType,pretty);
            if (!acc.equals("")){
                ret.add(acc);
            }
        }
        return ret;

    }
    public Map<String,String> getFileAccessions(){
        HashMap<String,String> ret = new HashMap<>();
        if (this.getValueAsString().equals("")){
            return ret;
        }         
        if (prettyList == null) init();
        for (PrettyWriter pretty : prettyList){
            String acc = getAccession("file",pretty);
            if (!acc.equals("")){
                String n = getPairedEnd(pretty);
                if (n != null){
                    ret.put(n, acc);
                }
            }
        }
        return ret;        
    }
    ArrayList<PrettyWriter> prettyList = null;  // this list has the json objects in the response, that can be displayed in the pretty way
}
