/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.cross.OffSpringStrain;
import org.rhwlab.LMS.rescue.RescueID;
import org.rhwlab.LMS.strain.ConstructID;
import org.rhwlab.LMS.strain.ReporterConstruct;
import org.rhwlab.LMS.strain.Strain;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class ConstructType extends TextCell {
    public ConstructType(){
        super("");
    }
    public void stateChanged(ChangeEvent event){
        if (locked) return;
        if (!this.getValueAsString().equals(""))return;
        Object source = event.getSource();
        String newValue = ((CellBase)source).getValueAsString();
        if (newValue.equals(""))return;                
        try {
            String type = null;
            if (source instanceof RescueID){
                type = ((RescueID)source).getConstructType();
            } else if (source instanceof ReporterConstruct ){
                type = ((ReporterConstruct)source).getType();
            } else if (source instanceof ConstructID){
                type = ((ConstructID)source).getConstructType();
            } else if (source instanceof OffSpringStrain){
                type = ((OffSpringStrain)source).getType();
            } else if (source instanceof Strain) {
                type = ((Strain)source).getType();
            }
            if (type != null){
                this.setValue(type);
                this.unlock();
            }
            
        } catch (Exception exc ){
            
        }
    }    
}
