
package org.rhwlab.LMS;

import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
abstract public class BooleanCell extends CellBase {
    public BooleanCell(){
        this (false);
    }
    public BooleanCell(boolean value){
        super(value);
    }
     @Override
    public String getValueAsString() {
        if (value == null) return "0";
            if ((Boolean)value){
                return "1";
            } else {
                return "0";
            }
    } 
    public boolean setValue(Object newValue,boolean notify){
        if (newValue instanceof String){
            String str = ((String)newValue).toLowerCase();
            if (str.equalsIgnoreCase("false")) return super.setValue(false);
            if (str.equalsIgnoreCase("true")) return super.setValue(true);
            if (str.equalsIgnoreCase("f")) return super.setValue(false);
            if (str.equalsIgnoreCase("t")) return super.setValue(true);
            if (str.equalsIgnoreCase("no")) return super.setValue(false);
            if (str.equalsIgnoreCase("yes")) return super.setValue(true);
            if (str.equals("0")) return super.setValue(false);
            if (str.equals("1")) return super.setValue(true); 
            if (str.equals("")) return super.setValue(false);
            return super.setValue(newValue);
        }
        return super.setValue(newValue,notify);        
        
    }     
    public boolean setValue(Object newValue){
        return setValue(newValue,true);
    }
    @Override
    public boolean validate(String newValue) {
        return true;
    }
    @Override
    public int compareTo(Object o) {
        BooleanCell other = (BooleanCell)o;
        return ((Boolean)value).compareTo((Boolean)other.value);
    }

    
}
