/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.util.ArrayList;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class ArrayListCell extends CellBase {
    public ArrayListCell(){
        super(new ArrayList<String>());
    }
    public ArrayListCell(ArrayList list){
        super(list);
    }
    @Override
    public boolean validate(String newValue) {
        return true;
    }
    public boolean setValue(Object newValue){
        return this.setValue(newValue, true);
    }
    public boolean setValue(Object obj,boolean notify){
        String[] tokens = new String[0];
        if (obj instanceof String){
            String str = (String)obj;
            tokens = str.split("\t");            
        }else if (obj instanceof String[]){
            tokens = (String[])obj;
        }

        ArrayList<String> list = new ArrayList<>();
        for (String token : tokens){
            list.add(token);
        }
        return super.setValue(list,notify);
    }
    @Override
    public String getValueAsString() {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> list = (ArrayList<String>)this.value;
        for (String str : list){
            builder.append(str);
            builder.append('\t');
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Object o) {
        ArrayListCell other = (ArrayListCell)o;
        return this.getValueAsString().compareTo(other.getValueAsString());
    }
    
}
