/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views.onsetmodel;
import javax.swing.*;
import java.awt.Color;
import java.awt.Component;
import javax.swing.border.TitledBorder;
import javax.swing.border.LineBorder;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.ExpOnsetsEmbryo;
import org.rhwlab.expression.ExpressionOnset;
import org.rhwlab.expression.ExpressionTimeSeries;
import org.rhwlab.expression.OnsetExpTimeSeries;
import org.rhwlab.expression.image.ValueRange;
/**
 *
 * @author gevirl
 */
public class OnsetsScroll extends JScrollPane implements ChangeListener {
    public OnsetsScroll(SeriesEmbryo embryo,HashMap onsetMap,Dimension dim){
        super();
        this.embryo = embryo;
        this.dim = dim;
//        this.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
        main = new JPanel();
        main.setLayout(new BoxLayout(main,BoxLayout.Y_AXIS));
            
        maxExp = Integer.MIN_VALUE;
        minExp = Integer.MAX_VALUE;
        leaves = embryo.getAllLeaves();
        int pos = 0;
        String user = System.getenv("USER");
        
        for (EmbryoCell leaf : leaves){
            JPanel panel = null;
            ExpressionTimeSeries timeSeries = null;
            if (embryo instanceof ExpOnsetsEmbryo ){
                timeSeries = OnsetExpTimeSeries.factory(leaf);
                EditOnsetPanel editOnsetPanel  = new EditOnsetPanel(this,(OnsetExpTimeSeries)timeSeries,user);
                editOnsetPanel.setDimension(dim);
                panel = editOnsetPanel;
                ((OnsetExpTimeSeries)timeSeries).addListener(this);
            }else {
                timeSeries = ExpressionTimeSeries.factory(leaf);
                Object[] annotations = null;
                Object onset = onsetMap.get(leaf.getName());
                if (onset != null){
                    if (onset instanceof List){
                        List list = (List)onset;
                        annotations = list.toArray(new Object[0]);
                    } else {
                        annotations = new Object[1];
                        annotations[0] = onset;
                    }
                }
                TimeSeriesPanel timeSeriesPanel = new TimeSeriesPanel(timeSeries,annotations);
                timeSeriesPanel.setDimension(dim);
                panel = timeSeriesPanel;
            }
            
            timeSeriesMap.put(leaf.getName(),timeSeries);
            int min = timeSeries.getMin();
            if (min < minExp) minExp = min;
            int max = timeSeries.getMax();
            if (max > maxExp) maxExp = max;

            panels.put(leaf.getName(),panel);
            panelIndex.put(timeSeries.getLabel(),new Integer(pos));

            JPanel borderPanel = new JPanel();
            borderPanel.setBorder(new TitledBorder(new LineBorder(Color.black,2),leaf.getName()));
            borderPanel.add(panel);
            prefer = borderPanel.getPreferredSize();  
            pos = pos + prefer.height;
            main.add(borderPanel);            
        }

        setScale(new ValueRange(minExp,maxExp));
        this.setViewportView(main);
        this.getViewport().addChangeListener(this); // this is to detect scrolling changes
    }
    private void buildPanels(){
        
    }
    public void moveTo(String leaf){
        if (topLeaf.equals(leaf)) return;
        JViewport port = this.getViewport();
        if (port == null) return;
        Integer loc = panelIndex.get(leaf);
        if (loc != null){
            Component view = port.getView();
            port.setViewPosition(new Point(0,loc));
            topLeaf = leaf;
            this.invalidate();
            this.repaint(); 
        }
    }
    public void notifyListeners(){
            ChangeEvent topEvent = new ChangeEvent(topLeaf);
            for (ChangeListener listen : listeners){
                listen.stateChanged(topEvent);
            }        
    }
    public void stateChanged(ChangeEvent event ){
        Object source = event.getSource();
        if (source instanceof EmbryoCell){
            EmbryoCell leaf = (EmbryoCell)event.getSource();
            EmbryoCell nearest = embryo.nearestLeaf(leaf);

            // move the time series for this leaf to the top of the viewport
            moveTo(nearest.getName());
        
        } else if (source instanceof OnsetsTreeScroll){
            
            moveTo(((OnsetsTreeScroll)source).getTopCell());
        }
    }
    final public void setScale(ValueRange range){
        for (JPanel panel : panels.values()){
            if (panel instanceof TimeSeriesPanel){
                TimeSeriesPanel tsPanel = (TimeSeriesPanel)panel;
                tsPanel.setScale(range);
            } else {
                EditOnsetPanel eoPanel = (EditOnsetPanel)panel;
                eoPanel.setScale(range);
            }
        }
        
    }
    public void setDimension(Dimension dim){
        this.dim = dim;
        for (JPanel panel : panels.values()){
            if (panel instanceof TimeSeriesPanel){
                TimeSeriesPanel tsPanel = (TimeSeriesPanel)panel;
                tsPanel.setDimension(dim);
            } else {
                EditOnsetPanel eoPanel = (EditOnsetPanel)panel;
                eoPanel.setDimension(dim);
            }            
            
        }        
    }
    public int getMinExpresion(){
        return minExp;
    }
    public int getMaxExpression(){
        return maxExp;
    }
    public ExpressionTimeSeries getTimeSeries(String leaf){
        return timeSeriesMap.get(leaf);
    }
    public void addListener(ChangeListener listen){
        listeners.add(listen);
    }
    public JPanel getLeafPanel(String leaf){
        return panels.get(leaf);
    }
    String topLeaf = "";
    EmbryoCell[] leaves;
    Dimension prefer;
    SeriesEmbryo embryo;
    Dimension dim;
    int minExp;
    int maxExp;
    JPanel main;
    HashMap<String,JPanel> panels = new HashMap<String,JPanel>();
    HashMap<String,Integer> panelIndex = new HashMap<String,Integer>();
    HashMap<String,ExpressionTimeSeries> timeSeriesMap = new HashMap<String,ExpressionTimeSeries>();
    ArrayList<ChangeListener> listeners = new ArrayList<ChangeListener>();
}
