package org.rhwlab.views.onsetmodel;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
import org.rhwlab.expression.image.*;
import javax.swing.JPanel;
import javax.swing.event.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.*;
import java.util.*;

import org.rhwlab.expression.*;
import org.rhwlab.beans.EmbryoCell;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import javax.swing.JOptionPane;
import org.rhwlab.expression.OnsetExpTimeSeries;

/**
 *
 * @author gevirl
 */
public class EditOnsetPanel extends JPanel implements ChangeListener {
    public EditOnsetPanel(OnsetsScroll par,OnsetExpTimeSeries ts,String us) {
        this.parent = par;
        user = us;
        image = new OnsetTimeSeriesImage();
        setTimeSeries(ts);
        this.addMouseListener(new MouseAdapter(){
            public void mouseClicked(MouseEvent e){
                ChangeEvent event = new ChangeEvent(e);
                int button = e.getButton();
                int mask = e.getModifiersEx();
                CellDataTimeSeries cdts = null;
                if (button == MouseEvent.BUTTON1 && mask ==0 ){
                    System.out.printf("Button 1: %d\n",mask);
                    // set the onset at mouse click location
                    mPressed = e.getPoint();
                    ExpressionOnset onset = new ExpressionOnset();
                    int sz = timeSeries.size();
                    int on = (int)(sz*(float)mPressed.x/(float)dim.width);                 
                    onset.setOnset(on);
                    onset.setMethod(user);
                    
                    // check with user first if moving an onset down the tree
                    ExpressionOnset currentOnset = timeSeries.getOnset();
                    if (currentOnset != null){
                        EmbryoCell oldOnsetCell = timeSeries.getCellByIndex(currentOnset.getOnset());
                        EmbryoCell newOnsetCell = timeSeries.getCellByIndex(on);
                        if (oldOnsetCell.hasChild(newOnsetCell.getName())){
                            ArrayList<EmbryoCell> leaves = oldOnsetCell.getLeavesExcept(newOnsetCell);
                            StringBuilder builder = new StringBuilder();
                            builder.append("This change removes the onset for the following leaves:\n");
                            for (EmbryoCell cell : leaves){
                                builder.append(cell.getName());
                                builder.append("\n");
                            }
                            builder.append("Do you want to proceed with the change?\n");
                            int response = JOptionPane.showConfirmDialog(null, builder.toString(), "Confirm Change of Expression Onset", JOptionPane.YES_NO_OPTION);
                            if (response == JOptionPane.NO_OPTION) return;
                            
                        }
                    }
                    
                    cdts = timeSeries.setOnset(onset);
                    AverageExpTimeSeries avg = AverageExpTimeSeries.factory(cdts.getCell());
                    
                    RegressionResult res = avg.doRegression(on,true);
                    onset.setBase(res.getBase());
                    onset.setSlope(res.getSlope());
                    onset.setType(cdts.getCell().getType());
                    onset.setConfidence(1.0);
                    onset.setCell(cdts.getCell().getName());
                    onset.setLeaf(timeSeries.getLastLabel());
                    onset.setSeries(cdts.getCell().fromSeries());
                    try {
                        onset.setSulston(cdts.getCell().toSulston(on));
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
                    
                    e.getComponent().repaint();
                } else if (button == MouseEvent.BUTTON3 || (button== MouseEvent.BUTTON1 && mask == 128)) {
                    // erase the onset
                    System.out.printf("Button 3: %d\n",mask);
                    cdts = timeSeries.setOnset(null);
                }
                parent.invalidate();
                parent.repaint();

                for (ChangeListener listen:listeners)
                    listen.stateChanged(event);
            }
        });
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        if (timeSeries == null)return;
        Graphics2D g2 = (Graphics2D) g;

        // clear the panel
        Color save = g2.getColor();
        g2.setColor(g2.getBackground());
        Dimension d = this.getSize();
        g2.fillRect(0,0,d.width,d.height);
        g2.setColor(save);
        
        g2.drawImage(image.getImage(),new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,0);
    }
    public final void setTimeSeries(OnsetExpTimeSeries ts) {
        timeSeries = ts;
        image.setTimeseries(ts);
        ts.addListener(this);
        this.invalidate();
        this.repaint();
    }

    // this is used for zooming in and out
    public Dimension setDim(int w,int h){
        // resize the image
        dim = new Dimension(w,h);
        image.setDimension(dim);
        
        this.setPreferredSize(dim);
        
        this.invalidate();
        return dim;
    }

    // null range will result in variable Y scale
    public void setYScale(ValueRange r){
        image.setYScale(r);
        this.invalidate();
        this.repaint();
    } 
    public void addListener(ChangeListener listen){
        listeners.add(listen);
    }
    public void setScale(ValueRange range){
        image.setYScale(range);
        this.invalidate();
        this.repaint();
    }
    public void setDimension(Dimension dim){
        this.dim = dim;
        image.setDimension(dim);
        this.setPreferredSize(new Dimension(dim.width,dim.height+30));
    }
    public OnsetTimeSeriesImage getImage(){
        return image;
    }
    OnsetsScroll parent;
    Point mPressed;
    OnsetExpTimeSeries timeSeries;
    Dimension dim;  // the size of the buffered image to draw
    OnsetTimeSeriesImage image;
    ArrayList<ChangeListener> listeners = new ArrayList<ChangeListener>();
    String user;

    @Override
    public void stateChanged(ChangeEvent e) {
        this.invalidate();
        this.repaint();
    }
    
}