/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views;
import javax.swing.*;
import java.awt.*;
import org.rhwlab.beans.*;
import org.rhwlab.expression.image.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.util.*;
/**
 *
 * @author gevirl
 */
public class TreePanel extends JPanel implements ChangeListener {
    public TreePanel() {
 //       image = new CompositeTreeImage(OnsetTreeImage.class);
        image = new CompositeTreeImage(ExpressionTreeImage.class);
 //       image.setDimension(d);
        this.addMouseListener(new MouseInputAdapter(){
            public void mouseClicked(MouseEvent event){
                String leaf = image.getLeafAt(event.getX(),event.getY());
                if (leaf == null) return;
                for (ChangeListener listen : listeners){
                    listen.stateChanged(new ChangeEvent(leaf));  // notify any object listening that a leaf cell has been selected
                }
            }
        }); 

        
    }
    public void useEmbryo(SeriesEmbryo emb){
        image.useSeries(emb);
    }
    public void setScale(int min,int max){
        image.setScale(min,max);
        this.invalidate();
        this.repaint();
    }
    public void stateChanged(ChangeEvent event){
        this.invalidate();
        this.repaint();
    }

    final public void setDimension(Dimension d){
        image.setDimension(d);
        this.setPreferredSize(d);
        this.invalidate();
        this.repaint();
    } 
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D) g;
        
        g2.drawImage(image.getImage(),new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,0);        

    }   
    public void addListener(ChangeListener listen){
        listeners.add(listen);
    }      
    Dimension dim;
    CompositeTreeImage image;
    ArrayList<ChangeListener> listeners = new ArrayList<>();    
}