/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class TreeFrame extends JFrame {
    public TreeFrame(){
        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        
        JPanel leafPanel = new JPanel();
        leafPanel.setLayout(new BoxLayout(leafPanel,BoxLayout.X_AXIS));      
       
        JButton xplus = new JButton("X+");
        xplus.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
                resizeImage(dim.width+inc,dim.height);
                validate();
            }
        });
        leafPanel.add(xplus);
        
        JButton xminus = new JButton("X-");
        xminus.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
                resizeImage(dim.width-inc,dim.height);
                validate();
            }
        });        
        leafPanel.add(xminus);
        
        JButton yplus = new JButton("Y+");
        yplus.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
                resizeImage(dim.width,dim.height+inc);
                validate();
            }
        });
        leafPanel.add(yplus);
        
        JButton yminus = new JButton("Y-");
        yminus.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
                resizeImage(dim.width,dim.height-inc);
                validate();
            }
        });        
        leafPanel.add(yminus);
        mainPanel.add(leafPanel,BorderLayout.PAGE_START); 
        
        
        minYScale = new JTextField("0");
        minYScale.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
                setScale();
            }
        });
        minYScale.setEnabled(true);
        leafPanel.add(new JLabel(" Minimum: "));
        leafPanel.add(minYScale);
        
       
        maxYScale = new JTextField();
        maxYScale.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
                setScale();
            }
        });        
        maxYScale.setEnabled(true);
        leafPanel.add(new JLabel(" Maximum: "));
        leafPanel.add(maxYScale);  
        
        displayMax = new JLabel();
        leafPanel.add(displayMax);
        
        

        treePanel = new TreePanel();
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(treePanel);
        mainPanel.add(scroll,BorderLayout.CENTER);
        treePanel.setDimension(dim);
        this.add(mainPanel);
        pack();

    }
    public void useSeries(String series)throws Exception {
        this.setTitle(series);  
        SeriesEmbryo emb = new SeriesEmbryo(MySql.getMySql(),series,"zblot");
        displayMax.setText("Max Expression: "+Integer.toString(emb.maxExpression()));
        maxYScale.setText("25000");
        treePanel.useEmbryo(emb);
        int leaves=0;
        for (EmbryoCell root : emb.getRoots()){
            leaves = leaves + root.getLeafCount();
        }
        dim = new Dimension(700,leaves*20);
        treePanel.setDimension(dim);
        setScale();
    }
    private void setScale(){
        int ymin = Integer.valueOf(minYScale.getText());
        int ymax = Integer.valueOf(maxYScale.getText());
        treePanel.setScale(ymin,ymax);
        validate();
    }
    private void resizeImage(int w,int h){
        dim = new Dimension(w,h);
        treePanel.setDimension(dim);
        
    }
    public TreePanel getTreePanel() {
        return treePanel;
    }
    static public void main(final String[] args)throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeFrame frame = new TreeFrame();
                try {
                    frame.useSeries("20120925_aha-1_2_L1");
                }catch (Exception exc){
                    exc.printStackTrace();
                }
                frame.setSize(500, 500);
                frame.setVisible(true);
            }
        });
    }
    int inc = 100;
    Dimension dim = new Dimension(700,900);
    TreePanel treePanel;
    JTextField minYScale;
    JTextField maxYScale;
    JLabel displayMax;
}
