package org.rhwlab.universalimaging;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeMap;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author gevirl
 */
public class CellLabels {
    TreeMap<String,String[]> map = new TreeMap<>();
    
    public CellLabels() throws Exception {
        InputStream stream = this.getClass().getResourceAsStream("/org/rhwlab/universalimaging/cell.labels.lineage.cell_deaths2.descr.tsv");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
            map.put(tokens[0].replace(".",""),tokens);
            line = reader.readLine();
        }
    }
    public String getLabel(String cell){
        String[] tokens = map.get(cell);
        if (tokens != null){
            StringBuilder builder = new StringBuilder();
            builder.append(tokens[0]);
            for (int i=1 ; i<tokens.length ; ++i){
                builder.append("\t");
                builder.append(tokens[i]);
            }
            return builder.toString();
        }
        
        return null;
    }
}
