/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.tfs;

import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class AllTFs extends TFResourceFile {

    CytoplasmicTFs cyto;
    TreeSet<String> geneNameSet;

    public AllTFs() {
        super("/org/rhwlab/tfs/allTFs.tsv");
        cyto = new CytoplasmicTFs();
        try {
            geneNameSet = new TreeSet<>(this.asGeneName());
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    // return the wbgene of the non cytoplasmic tfs
    public Set<String> getNonCytoplasmicTFs() throws Exception {
        List<String> cytoWBGenes = cyto.asWBGene();
        TreeSet<String> cytoSet = new TreeSet(cytoWBGenes);

        TreeSet<String> ret = new TreeSet<>();
        for (String tf : this.asWBGene()) {
            if (!cytoSet.contains(tf)) {
                ret.add(tf);
            }
        }
        return ret;

    }

    public Set<String> getNonCytoplasmicGeneNameTFs() throws Exception {
        List<String> cytoGenes = cyto.asGeneName();
        TreeSet<String> cytoSet = new TreeSet(cytoGenes);

        TreeSet<String> ret = new TreeSet<>();
        for (String tf : this.asGeneName()) {
            if (!cytoSet.contains(tf)) {
                ret.add(tf);
            }
        }
        return ret;
    }    
    public boolean containsGeneName(String name) {
        return geneNameSet.contains(name);
    }

    static public void main(String[] args) throws Exception {
        AllTFs all = new AllTFs();
        Set<String> non = all.getNonCytoplasmicTFs();
        int ausdhfuisd = 0;
    }
}
