/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.singlecell.randomforest;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.rhwlab.db.MySql;
import org.rhwlab.singlecell.L2.CellTypeGeneExp;

/**
 *
 * @author gevirl
 */
public class TF_TableModel extends AbstractTableModel {

    String[] columnNames = {"TF", "Chipped", "Importance", "Normalized (Sum=1000)", "Rank for TF", "BriefDesc"};
    List<Object[]> data = new ArrayList<>();
    
    public TF_TableModel(String target, String expFile) throws Exception {
        this(target,expFile,null,null,null);
    }
    public TF_TableModel(String target, String expFile, TreeMap<String, double[]> expData, String[] abbrs, Set<String> chippedTFs) throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Select * from ScoredTargetTFs where ExpressionFile = ? and TargetGene = ? order by RankForTargetInFile asc");
        state.setString(1, expFile);
        state.setString(2, target);

        ResultSet rs = state.executeQuery();

        double total = 0.0;
        while (rs.next()) {
            Object[] objs = new Object[columnNames.length];
            objs[0] = rs.getString("TF");
            objs[1] = "";
            if (chippedTFs != null && chippedTFs.contains(objs[0])) {
                objs[1] = "X";
            }

            objs[2] = rs.getDouble("Importance");
            total = total + (Double) objs[2];
            objs[3] = rs.getDouble("NormalizedImportance");
            objs[4] = rs.getInt("RankForTargetInFile") + 1;

            if (abbrs != null && expData != null) {
                double[] x = expData.get((String) objs[0]);
                if (x != null) {
                    String brief = CellTypeGeneExp.briefDesc(x, abbrs);
                    if (brief != null) {
                        objs[5] = brief;
                    }
                }
            }

            this.addRow(objs);
        }

        // normalize the importance
        for (int r = 0; r < this.getRowCount(); ++r) {
            this.setValueAt(1000.0 * (Double) this.getValueAt(r, 2) / total, r, 3);
        }
    }

    static public List getTFs(String expFile)throws Exception {
        ArrayList<String> ret = new ArrayList<>();
        
        PreparedStatement state = MySql.getMySql().getStatement("Select distinct TF from ScoredTargetTFs where ExpressionFile = ? ");
        state.setString(1, expFile);

        ResultSet rs = state.executeQuery();

        double total = 0.0;
        while (rs.next()) {
            ret.add(rs.getString("TF"));
        }

        return ret;
    }
    @Override
    public void setValueAt(Object v, int r, int c) {
        Object[] rowData = data.get(r);
        rowData[c] = v;
    }

    @Override
    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }

    public void addRow(Object[] row) {
        data.add(row);
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return data.get(rowIndex)[columnIndex];
    }

    // return a row of the table as a ScoredFeature
    public ScoredFeature asScoredFeature(int row) {
        String tf = (String) this.getValueAt(row, 0);
        double score = (Double) this.getValueAt(row, 3);
        int rank = (Integer) this.getValueAt(row, 4);
        return new ScoredFeature(tf, score, rank);
    }

    public Map<String, ScoredFeature> allScoredFeatures() {
        TreeMap<String, ScoredFeature> ret = new TreeMap<>();
        for (int row = 0; row < data.size(); ++row) {
            ScoredFeature sf = asScoredFeature(row);
            ret.put(sf.getName(), sf);
        }
        return ret;
    }


}
