/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
// data from the WormBaseGene Table
public class WormBaseGene {
    public WormBaseGene()throws Exception {

    }
    
    // try to construct the object given a gene name
    // gene name can be either CGC or Sequence
    static public WormBaseGene byGeneColumn(String geneCol)throws Exception {
   
        WormBaseGene WBGene=null;
        org.rhwlab.db.beans.Gene gene = new org.rhwlab.db.beans.Gene();
        gene.fromMySqlByCGC(MySql.getMySql(), geneCol);   
        if (gene.getWBGene() != null){
            WBGene = WormBaseGene.byWBGene(gene.getWBGene());
        }
        else {
            gene.fromMySqlBySequence(MySql.getMySql(), geneCol);
            if (gene.getWBGene() != null)
                WBGene = WormBaseGene.byWBGene(gene.getWBGene());
            else {
                WBGene = WormBaseGene.byGene(geneCol);
          
            }
        } 
        return WBGene;
    }
    static WormBaseGene byGene(String gene)throws Exception {
        WormBaseGene ret = WormBaseGene.byCGC(gene);
        if (ret == null){
            ret = WormBaseGene.bySequence(gene);
        }
        return ret;
    }

    // try to construct a WormBaseGene given a CGC name 
    // will use the DeadGene table if necessary
    // returns null if not able to match to a live WBGene
    static public WormBaseGene byCGC(String cgc)throws Exception {
        if (selectCGC == null) {
            selectCGC = 
                MySql.getMySql().getStatement("Select * from WormBaseGene where CGC = ?");
        }
        selectCGC.setString(1,cgc);
        ResultSet rs = selectCGC.executeQuery();
        if (rs.next()){
            WormBaseGene WBGene = new WormBaseGene();
            WBGene.fromRS(rs);
            if (!WBGene.status.equals("Dead")){
                return WBGene;
            } else {
                return byDeadWBGene(WBGene.wbGene);
            }
        } 
        return null;
    }
    static public WormBaseGene bySequence(String sequence)throws Exception {
        if (selectSeq == null){
            selectSeq = 
                MySql.getMySql().getStatement("Select * from WormBaseGene where Sequence = ?");
        }
        selectSeq.setString(1,sequence);
        ResultSet rs = selectSeq.executeQuery();
        if (rs.next()){
            WormBaseGene WBGene = new WormBaseGene();
            WBGene.fromRS(rs);
            if (!WBGene.status.equals("Dead")){
                return WBGene;
            } else {
                return byDeadWBGene(WBGene.wbGene);
            }
        } 
        return null;        
    }
    static public WormBaseGene byDeadWBGene(String dead) throws Exception {
        if (selectDead == null){
            selectDead = MySql.getMySql().getStatement("Select * from DeadWBGene where Dead = ?");
        }
        selectDead.setString(1, dead);
        ResultSet rs = selectDead.executeQuery();
        if (rs.next()){
            String merged = rs.getString("MergedInto");
            return byWBGene(merged);
        }
        return null;
    }
    static public WormBaseGene byWBGene(String wbGene) throws Exception {
        if (selectWBGene == null){
            selectWBGene = MySql.getMySql().getStatement("Select * from WormBaseGene where WBGene = ?");
        }
        selectWBGene.setString(1, wbGene);
        ResultSet rs = selectWBGene.executeQuery();
        if (rs.next()){
            WormBaseGene ret = new WormBaseGene();
            ret.fromRS(rs);
            if (!ret.status.equals("Dead")){
                return ret;
            } else {
                return byDeadWBGene(wbGene);
            }
        }
        return null;
    }
    static public WormBaseGene byTranscript(String transcript) throws Exception {
        if (selectTranscript == null){
            selectTranscript = MySql.getMySql().getStatement("Select * from Transcript where TranscriptName = ?");
        }
        selectTranscript.setString(1, transcript);
        ResultSet rs = selectTranscript.executeQuery();
        if (rs.next()){
            String wbGene = rs.getString("WBGene");
            return WormBaseGene.byWBGene(wbGene);
        }
        return null;
        
    }
    private void fromRS(ResultSet rs)throws Exception {
        this.wbGene = rs.getString("WBGene");
        this.cgc = rs.getString("CGC");
        this.seq = rs.getString("Sequence");
        this.status = rs.getString("Status");
    }
    public String getWBGene(){
        return this.wbGene;
    }
    public String getCGC(){
        return this.cgc;
    }
    public String getSequence(){
        return this.seq;
    }
    static PreparedStatement selectCGC = null;
    static PreparedStatement selectSeq = null;
    static PreparedStatement selectDead = null;
    static PreparedStatement selectWBGene = null;
    static PreparedStatement selectTranscript = null;
    String wbGene;
    String cgc;
    String seq;
    String status;
}
