/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.modencode;
import org.intermine.metadata.Model;
import org.intermine.webservice.client.core.ServiceFactory;
import org.intermine.webservice.client.services.ModelService;
import org.intermine.webservice.client.services.QueryService;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.Constraints;

import org.rhwlab.db.beans.Gene;
import org.rhwlab.db.beans.GeneRegion;
import org.rhwlab.db.MySql;
import java.util.List;
/**
 *
 * @author gevirl
 */
public class TSS {
    // contruct the TSS using modencode given the Gene 
    public TSS(Gene gene){
        ServiceFactory factory = new ServiceFactory(ROOT);
        Model model = factory.getModelService().getModel();
        QueryService service = factory.getQueryService();   
        PathQuery query = new PathQuery(model);
        
        // Add views
        query.addViews("Gene.chromosomeLocation.start",
                "Gene.chromosomeLocation.end",
                "Gene.chromosome.primaryIdentifier",
                "Gene.chromosomeLocation.strand");

        // Add orderby
        query.addOrderBy("Gene.chromosomeLocation.start", OrderDirection.ASC);

        // Add constraints and you can edit the constraint values below
        query.addConstraint(Constraints.eq("Gene.primaryIdentifier", gene.getWBGene()));
                
        List<List<String>> result = service.getAllResults(query);
                
        if (!result.isEmpty()){
            List<String> row = result.get(0);
            region = new GeneRegion(row.get(2),Integer.valueOf(row.get(0)),Integer.valueOf(row.get(1)),Integer.valueOf(row.get(3)));
        }        
    }
    public GeneRegion getRegion(){
        return region;
    }
    public static void main(String[] args){
        // find a wbgene from the database'
        try{
            MySql db = MySql.getMySql();
            Gene gene = new Gene();
            gene.fromMySqlByAlias(db, args[0]);
            TSS tss = new TSS(gene);
            int iuashfius=0;
        }catch(Exception exc){
            exc.printStackTrace();
        }
    }
    GeneRegion region;
    private static final String ROOT = "http://intermine.modencode.org/release-27/service";    
}
