/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.meme;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalTreeMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

/**
 *
 * @author gevirl
 */
public class FimoFile {

    TreeMap<String, IntervalTreeMap<FimoRecord>> maps = new TreeMap<>();



    // construct from a tsv file
    public FimoFile(String tsv) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(tsv));
        String[] heads = reader.readLine().split("\t");

        String line = reader.readLine();
        while (line != null) {
            if (!line.isEmpty() && !line.startsWith("#")) {
                FimoRecord motif = new FimoRecord(heads, line);
                String motifID = motif.getValue("motif_alt_id");
                IntervalTreeMap<FimoRecord> map = maps.get(motifID);
                if (map == null) {
                    map = new IntervalTreeMap<FimoRecord>();
                    maps.put(motifID, map);
                }
                map.put(motif.asInterval(), motif);
            }
            line = reader.readLine();
        }
        reader.close();
    }

    public TreeMap<String, Collection> getContainedIn(Interval i) {
        TreeMap<String, Collection> ret = new TreeMap<>();
        for (String id : maps.keySet()) {
            ret.put(id, maps.get(id).getContained(i));
        }
        return ret;
    }

    public Set<String> getMotifIDs() {
        return maps.keySet();
    }

    static public void main(String[] args) throws Exception {
        FimoFile f = new FimoFile("/net/waterston/vol2/home/gevirl/MEME/E9/ztf-4/fimo_out_all/fimo.tsv");
        Interval test = new Interval("chrX", 15275400, 15275600);
        TreeMap<String, Collection> result = f.getContainedIn(test);
        int tasdfuisd = 0;
    }
}
