
package org.rhwlab.imaging.multitree;
import javax.swing.*;
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.*;
import java.awt.image.*;
import java.util.List;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.db.MySql;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseEvent;
/**
 *
 * @author gevirl
 */

public class MultiTreePanel extends JPanel {
    public MultiTreePanel(MySql db,List<SeriesEmbryo> embryos) throws Exception {
        image = new MultiEmbryoTreeImage(db,embryos) ;
        this.setPreferredSize(image.getDimension());
        this.addMouseMotionListener(new MouseMotionAdapter(){
            public void mouseMoved(MouseEvent event){
                x = event.getX();
                y = event.getY();
                String lab = image.getLabelAt(x,y);
                mouseLabel = null;
                if (lab != null){
                    String[] tokens = lab.split("/");
                    mouseLabel = tokens[0];
                }
                repaint();
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D) g;
        
        // clear the panel
        Color save = g2.getColor();
        g2.setColor(Color.white);
        Dimension d = this.getSize();
        g2.fillRect(0,0,d.width,d.height);
        g2.setColor(save);
        
        try {
        g2.drawImage(image.getImage(),
                new AffineTransformOp(new AffineTransform(),AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,0);
        } catch (Exception exc){
            exc.printStackTrace();
        }
        if (mouseLabel != null){
            g2.drawString(mouseLabel,x,y);
        }
    }     

    MultiEmbryoTreeImage image;
    int x;
    int y;
    String mouseLabel = null;
}
