/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;
import java.awt.*;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.expression.image.ExpressionScaleImage;
/**
 *
 * @author gevirl
 */
public class VerticalTreeImage {
    public VerticalTreeImage(String title,BinaryTreeNode r,int height, float timeScale,int labelWidth,double maxTime) throws Exception {
        if (sulston == null){
            sulston = new SulstonEmbryo();
        }
        this.height = height;
        this.labelWidth = labelWidth;
        this.root = r;
        this.timeScale = timeScale;
        this.title = title;
        this.maxTime = maxTime;
        this.dim = new Dimension((int)(maxTime*timeScale)+labelWidth,height);
        startTime = 0;
        if (this.root instanceof EmbryoCell){
 //           startTime = ((EmbryoCell)root).getStartTime();
            startTime = ((EmbryoCell)root).getSulstonStart();
        }        
    }
 
    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(dim.width,dim.height,BufferedImage.TYPE_INT_ARGB);
        int treeWidth = dim.width;
        if (labelLeaves) treeWidth = treeWidth - labelWidth;
        Graphics2D g2 = image.createGraphics();
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, dim.width, dim.height);        
         
//        timeScale = (float)treeWidth/(float)maxTime;
        
        // draw the tree 
        float leftOffset = (float)50.0;
        drawNode(g2,root,leftOffset+(int)(timeScale*startTime),15,dim.width,dim.height-30);
        
        // put a time scale on the bottom

//
        
        for (double t=0 ; t<maxTime ; t=t+50){
            float p = (float)t*timeScale + leftOffset;
            g2.setColor(Color.BLACK);
            g2.drawString(Integer.toString((int)(t)), p, dim.height);
        }     
//        g2.drawString(Integer.toString(maxTime), maxTime*timeScale, dim.height);
        
        // draw the annotations
        for (AnnotationImage annotation : annotations){
            annotation.drawAnnotation(g2);
        }
        
        // draw the marks placed on the tree
        int del = 8;
        Stroke stroke = new BasicStroke(3);
        g2.setStroke(stroke);
        for (TreeMark mark : marks){
            // get the line rectangle
            Rectangle2D rect = this.lineLocs.get(mark.getLabel());
            
            //draw a vertical line at the mark
            Integer count = valueCounts.get(mark.getLabel());
            double f = ((double)mark.getValue())/count.doubleValue();
            int x = (int)(rect.getX()+rect.getWidth()*f);
            int y = (int)(rect.getY() + rect.getHeight()/2.0 - del);
            g2.drawLine(x, y, x, y+2*del);
        }
        g2.drawString(title,(int)(1.7*leftOffset), 12);
        return image;
    }
    private void drawNode(Graphics2D g2,BinaryTreeNode node,float x0,float y0,float x1,float y1){
        float dy = y1 - y0;
        
        // get the length of time for this node
//        float time = node.getValues().length;
        float time = 0;
        try {
            time = (float)(((EmbryoCell)node).getSulstonEnd() - ((EmbryoCell)node).getSulstonStart());
        } catch (Exception exc){
            exc.printStackTrace();
        }
        float xs = x0;
        float xe = xs+ time*timeScale;
        float y = y0 + dy/2;
        
      
        // draw the children nodes
        BinaryTreeNode lessNode = node.getLessDaughter();
        BinaryTreeNode greatNode = node.getGreaterDaughter();
        float ym=0;
        if (lessNode != null && greatNode != null){
            float leavesUp = Utils.getLeaves(lessNode).size();     
            float leavesDn = Utils.getLeaves(greatNode).size();
            ym = y0+dy*(leavesUp/(leavesUp+leavesDn));
            drawNode(g2,lessNode,xe,y0,x1,ym);
            drawNode(g2,greatNode,xe,ym,x1,y1);
            if (this.labelNodes){
                g2.setColor(Color.BLACK);
                g2.drawString(node.getLabel(),xs, y-nodeImage.getLineWidth());            
            }            
        } else {
            if (this.labelLeaves){
                // draw the cell label
                g2.setColor(Color.BLACK);
                
                String leafLabel = node.getLabel();
                if (this.showCellFates){
                    Set<String> fates = sulston.getCellFates(leafLabel);
                    for (String fate : fates){
                        leafLabel = leafLabel+","+fate;
                    }
                }
                g2.drawString(leafLabel,xe, y);
                // save the location of the cell name string in the image
                Rectangle2D r = g2.getFont().getStringBounds(leafLabel,g2.getFontRenderContext());
                r.setRect(r.getX()+xe, r.getY()+y, r.getWidth(), r.getHeight());
                leafLocs.put(leafLabel,r);
            }
        }
        
        // draw the horizontal line
        Rectangle2D.Float nodeRect = new Rectangle2D.Float(x0,y0,xe-xs,y1-y0);
        nodeImage.drawHorizontal(node, nodeRect, ym, g2);
        List<LabeledRectangle> rList = nodeImage.getRectangles();
        for (LabeledRectangle lRect : rList){
            lineLocs.put(lRect.getLabel(),lRect.getRectangle());
            valueCounts.put(node.getLabel(),node.getValues().length);
        }
    }      
    public void setLabelLeaves(boolean b){
        this.labelLeaves = b;
    }
    public void setLabelNodes(boolean b){
        this.labelNodes = b;
    }
    public void setNodeImage(NodeImage ni){
        this.nodeImage = ni;
    }
    public NodeImage getNodeImage(){
        return this.nodeImage;
    }
    public void addAnnotation(AnnotationImage ann){
        annotations.add(ann);
    }
    public void setColorScale(ColorScale colorScale){
        this.colorScale = colorScale;
        this.nodeImage.setColorScale(colorScale);
        // add a scale annotation to the left of the image
        ExpressionScaleImage scaleImage = new ExpressionScaleImage();
        scaleImage.setPosition(10,10);
        scaleImage.setDimension(new Dimension(20,Math.min(500,dim.height)));
        scaleImage.setColorScale(colorScale);
        this.addAnnotation(scaleImage);        
    }
    public void setLineWidth(int w){
        nodeImage.setLineWidth(w);
    }
    public String getLabelAt(int x,int y){
        for (String label  : lineLocs.keySet()){
            Rectangle2D rect = lineLocs.get(label);
            if (rect.contains(x, y)){
                return label;
            }
        }
        return null;
    }
    public void addMark(TreeMark mark){
        marks.add(mark);
    }
    // finds the leaf string printed at location x,y - used for interpreting mouse clicks
    public String getLeafAt(int x,int y){
        for (String leaf : leafLocs.keySet()){
            Rectangle2D rect = leafLocs.get(leaf);
            if (rect.contains((double)x, (double)y)){
                return leaf;
            }
        }
        return null;
    }    

        public String getLeafAt(int y){
        for (String leaf : leafLocs.keySet()){
            Rectangle2D rect = leafLocs.get(leaf);
            if (rect.getMinY()<= y && y<=rect.getMaxY()){
                return leaf;
            }
        }
        return null;
    }
    public Rectangle2D getRectForCell(String cellName){
        Rectangle2D ret = leafLocs.get(cellName);
        if (ret != null) return ret;
        
        ret = lineLocs.get(cellName);
        return ret;
    }
    public Dimension getSize(){
        return this.dim;
    }
    static SulstonEmbryo sulston;
    float timeScale;
    int height;
    int labelWidth;
    double startTime;
    
    String title;
    double maxTime;
    
    TreeMap<String,Rectangle2D> leafLocs= new TreeMap<String,Rectangle2D>();    // keeping track of the locations of the leaf labels
    HashMap<String,Rectangle2D> lineLocs = new HashMap<String,Rectangle2D>();   // recording the locations of the cell horizontal lines
    ArrayList<AnnotationImage> annotations = new ArrayList<AnnotationImage>();
    ArrayList<TreeMark> marks = new ArrayList<TreeMark>();
    HashMap<String,Integer> valueCounts = new HashMap<String,Integer>();

    BinaryTreeNode root;  // the root of the tree to draw 
    Dimension dim;  // size of the image in pixels
    
    NodeImage nodeImage = new SingleNodeImage(); 
    ColorScale colorScale;
    boolean labelLeaves = true;
    boolean labelNodes = false;
    boolean showCellFates = true;
    
}
