/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;
import java.util.*;
/**
 *
 * @author gevirl
 */
public class Utils {
    // find the maximum depth of a tree (the number of values in the longest path to a leaf) 
    static public int getMaxDepth(BinaryTreeNode node){
        int l = node.getValues().length;
        
        if (Utils.isLeaf(node)){
            return l;
        }
        if (node.getLessDaughter() == null){
            return l + Utils.getMaxDepth(node.getGreaterDaughter());
        }
        if (node.getGreaterDaughter() == null) {
            return l + Utils.getMaxDepth(node.getLessDaughter());
        }
        return l + Math.max(Utils.getMaxDepth(node.getGreaterDaughter()),Utils.getMaxDepth(node.getLessDaughter()));
    }
    // return a List of all the leaves of a given tree root
    static public List<BinaryTreeNode> getLeaves(BinaryTreeNode root){
        ArrayList ret = new ArrayList<BinaryTreeNode>();
        
        if (Utils.isLeaf(root)){
            ret.add(root);
            return ret;
        }
        
        if (root.getLessDaughter() != null){
            ret.addAll(Utils.getLeaves(root.getLessDaughter()));
        }
        if (root.getGreaterDaughter() != null){
            ret.addAll(Utils.getLeaves(root.getGreaterDaughter()));
        }
        return ret;
    }
    static boolean isLeaf(BinaryTreeNode node){
        return (node.getLessDaughter()==null) && (node.getGreaterDaughter()==null);
    }
}
