/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;
import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import org.rhwlab.beans.*;
import java.awt.geom.*;
import java.awt.*;
/**
 *
 * @author gevirl
 */
// a tree node that is draw with multiple embryos
public class MultiNodeImage implements NodeImage {
    MultiNodeImage(){
        colorScales = new HashMap<String,DefaultColorScale>();
        embryos = new ArrayList<SeriesEmbryo>();
    }
    public MultiNodeImage(List<SeriesEmbryo> embryoList){
        this();
        for (SeriesEmbryo embryo : embryoList){
            addEmbryo(embryo);
        }
    }
    public void addEmbryo(SeriesEmbryo embryo){
        int maxExp = embryo.maxExpression();
        colorScales.put(embryo.getID(),new DefaultColorScale(0,maxExp,Gradient.GRADIENT_RAINBOW));
        embryos.add(embryo);
    }
    // yMid is the 
    public void  drawHorizontal(BinaryTreeNode node,Rectangle2D.Float r,float yMid,Graphics2D g2){
        EmbryoCell sulstonCell = (EmbryoCell)node;
        float y = r.y + (r.height-getLineWidth())/2;
        rect = new Rectangle2D.Float(r.x,y-1,r.width,getLineWidth()+2); 
        
        this.rectList = new ArrayList<LabeledRectangle>();
        
        // draw the horizontal lines (as rectangles) 
        for (SeriesEmbryo embryo : embryos){
            DefaultColorScale colorScale = colorScales.get(embryo.getID());
            int maxexp = colorScale.max;
            EmbryoCell cell = embryo.getCell(node.getLabel());

            if (cell != null){

                int[] exps = cell.getExpTimeSeries().getValues();
                float deltaX = (r.width)/(exps.length);
                if (cell.isLeaf()){
                    try {
                    float cellEndTime = cell.toSulston(cell.getEndTime());
                    float cellStartTime = cell.toSulston(cell.getStartTime());
                    float sulsEndTime = sulstonCell.getEndTime();
                    float sulsStartTime = sulstonCell.getStartTime();
                    float f = (cellEndTime-cellStartTime)/(sulstonCell.getEndTime()-sulstonCell.getStartTime());
                    if (f < 1.0){
                        cellEndTime = cell.toSulston(cell.getEndTime());
                        cellStartTime = cell.toSulston(cell.getStartTime());                       
                        deltaX = f*r.width/exps.length;
                    }
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
                    
                }
                
                rectList.add(new LabeledRectangle(embryo.getID()+"/"+cell.getName(),new Rectangle2D.Float(r.x,y,r.width,lineWidth)));
                for (int i=0 ; i<exps.length ; ++i){
                    float x = r.x + i*deltaX;
                    Rectangle2D lr  = new Rectangle2D.Float(x,y,deltaX,(float)lineWidth);
                    g2.setColor(colorScale.getColor(exps[i]));
                    g2.fill(lr); 
                }
            }
            y = y + lineWidth;
        }

        // draw horizontal lines 
        g2.setColor(Color.black);
        float y0 = r.y + (r.height-getLineWidth())/2;
        float yn = y0-lineWidth;
        if (embryos.size()>1){
            for (int i=0 ; i<=embryos.size();++i){
                yn = yn + lineWidth;
                Line2D hline = new Line2D.Float(r.x,yn,r.x+r.width,yn);
                g2.draw(hline);    
                
            }
        }
        
        // draw the vertical line if not a leaf 
        if (node.getLessDaughter()!=null && node.getGreaterDaughter()!=null){
            // draw an up line
            float xR = r.x+r.width;
            Line2D line = new Line2D.Float(xR,(r.y+yMid)/2-getLineWidth()/2,xR,(r.y+r.height+yMid)/2+getLineWidth()/2);
            g2.setColor(Color.black);
            g2.draw(line);
        } else {
            // close the leaf with a vertical line
                Line2D hline = new Line2D.Float(r.x+r.width,y0,r.x+r.width,yn);
                g2.draw(hline);            
        }
        
          
    }
    public void setColorScale(ColorScale scale){
        
    }
    public void setLineWidth(int w){
        this.lineWidth = w;
    }
    public int getLineWidth(){
        return embryos.size()*lineWidth;
    }
    public Rectangle2D getBoundingRectangle(){
        return rect;
    } 
    public List<LabeledRectangle> getRectangles(){
        return this.rectList;
    }
    Rectangle2D rect;       
    int lineWidth = 10;
    List<SeriesEmbryo> embryos;
    HashMap<String,DefaultColorScale> colorScales;
    List<LabeledRectangle> rectList;
    
    

}

