
package org.rhwlab.imaging.binarytree;
import java.awt.Color;
/**
 *
 * @author gevirl
 */
public class DefaultColorScale implements ColorScale {
    // define a rainbow scale with min of zero and max of 5000
    public DefaultColorScale(){
        this(0,5000);
    }
    // define a rainbow color scale with the given minimum and maximum values
    public DefaultColorScale(int min,int max){
        this(min,max,Gradient.GRADIENT_RAINBOW);
    }
    // define a color scale
    // use the lowest color for any value less than the minimum
    //use the highest color for any value greater than the maximum
    // divides the scale into equal partitions from min to max
    public DefaultColorScale(int min,int max,Color[] c){
        this.min = min;
        this.max = max;       
        colors = c;
        delta = (max-min)/c.length;
    }
    public Color getColor(int value){
        if (value <= min){
            return colors[0];
        }
        if (value > max){
            return colors[colors.length-1];
        }
        int index = (int)((value-min)/delta);
        if (index > colors.length-1) index = colors.length-1;
        return colors[index];
    }
    public Color[] getColors(){
        return this.colors;
    }
    public int getMin(){
        return this.min;
    }
    public int getMax(){
        return this.max;
    }
    int min;
    int max;
    float delta;
    Color[] colors; 
}
