/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging;
import ij.ImagePlus;
import ij.process.ColorProcessor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.CompositeContext;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
/**
 *
 * @author gevirl
 */
public class TIFF {
    /*
    public TIFF(){
        
    }
    
    public TIFF(String directory,int time,int plane){
        this.time = time;
        this.plane = plane;
        labels = new ArrayList<Label>();
        
        File dir = new File(directory +"/tif");
        File[] files = dir.listFiles(new FilenameFilter(){
            public boolean accept(File dir,String name){
                return name.contains(String.format("t%03d-p%02d",TIFF.this.time,TIFF.this.plane));
            }
        });
        if (files.length > 0){
            lineageFile = files[0];
        } 

        dir = new File(directory+"/tifR");
        files = dir.listFiles(new FilenameFilter(){
            public boolean accept(File dir,String name){
                return name.contains(String.format("t%03d-p%02d",TIFF.this.time,TIFF.this.plane));
            }
        });
        if (files.length > 0){
            expressFile = files[0];
        } 
    }
   */
    // the provided directory is the image directory from the series meta data
    public TIFF(String directory) throws Exception{
        status = false;
        this.time = 1;
        this.plane = 1;
        labels = new ArrayList<Label>();
        File dir = new File(directory +"/tif");
      
        if (!dir.exists()){
            System.out.printf("TIFF error: unknown: %s\n", directory);
            return;
        }
        File[] files = dir.listFiles(new FilenameFilter(){
            public boolean accept(File dir,String name){
                return name.contains(String.format("t%03d-p%02d",TIFF.this.time,TIFF.this.plane));
            }
        });
        if (files.length > 0){
            lineageFile = files[0];
        } 

        dir = new File(directory+"/tifR");
        files = dir.listFiles(new FilenameFilter(){
            public boolean accept(File dir,String name){
                return name.contains(String.format("t%03d-p%02d",TIFF.this.time,TIFF.this.plane));
            }
        });
        if (files.length > 0){
            expressFile = files[0];
        } 
        status = true;
    }
    public boolean isOK(){
        return status;
    }
    public void setTimeAndPlane(int time,int plane){
        this.time = time;
        this.plane = plane;
        String lineageName = this.lineageFile.getPath();
        lineageName = lineageName.replaceFirst("\\-t\\d{3}",String.format("-t%03d",time));
        lineageName = lineageName.replaceFirst("\\-p\\d{2}",String.format("-p%02d",plane));
        this.lineageFile = new File(lineageName);
        
        if (this.expressFile != null){
            String expressName = this.expressFile.getPath();
            expressName = expressName.replaceFirst("\\-t\\d{3}",String.format("-t%03d",time));
            expressName = expressName.replaceFirst("\\-p\\d{2}",String.format("-p%02d",plane));
            this.expressFile = new File(expressName);     
        }
    }
    public BufferedImage getImage(boolean lineaging,boolean expression){
        if (!lineaging && !expression)return null;
        
        byte[] green= null;
        byte[] red = null;
        byte[] blue = null;
        ImagePlus iPlus = null;
        if (lineaging){
            iPlus = ij.IJ.openImage(lineageFile.getPath());
            green = (byte[])iPlus.getProcessor().getPixels();
            blue = new byte[green.length];
        }
        if (expression){
            iPlus = ij.IJ.openImage(expressFile.getPath());
            red = (byte[])iPlus.getProcessor().getPixels();
            blue = new byte[red.length];
        } 
        Arrays.fill(blue, (byte)0);
        if (!lineaging) {
            green = new byte[red.length];
            Arrays.fill(green,(byte)0);
        }
        if (!expression){
            red = new byte[green.length];
            Arrays.fill(red,(byte)0);
        }
        
        int w = iPlus.getProcessor().getWidth();
        int h = iPlus.getProcessor().getHeight();
        ColorProcessor colorProcess = new ColorProcessor(w,h);
        colorProcess.setRGB(red, green, blue);
        BufferedImage image = colorProcess.getBufferedImage();
        
        // put on the labels
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        for (Label label : labels){
            g2.drawString(label.text,label.x,label.y);
        }
        
        return image;
    }
    public BufferedImage getImage(Color lineageColor,Color expressColor,int rule){
        BufferedImage lineageImage = null;
        BufferedImage expressImage = null;
        if (lineageColor != null){
            ImagePlus iPlus = ij.IJ.openImage(lineageFile.getPath());
            lineageImage = getBufferedImage(iPlus,lineageColor);
            if (expressColor == null) return lineageImage;
        }
        if (expressColor != null){
            ImagePlus iPlus = ij.IJ.openImage(expressFile.getPath());
            expressImage = getBufferedImage(iPlus,expressColor);
            if (lineageColor == null) return expressImage;
        }    
        AlphaComposite composite = AlphaComposite.getInstance(rule);
        CompositeContext context = composite.createContext(lineageImage.getColorModel(),expressImage.getColorModel(),null);        
        context.compose(lineageImage.getRaster(),expressImage.getRaster(),expressImage.getRaster());
        return expressImage;
    }
    public BufferedImage getBufferedImage(ImagePlus iPlus,Color color){
        int w = iPlus.getProcessor().getWidth();
        int h = iPlus.getProcessor().getHeight();        
        BufferedImage ret = new BufferedImage(w,h,BufferedImage.TYPE_INT_ARGB);
        byte[] lineagePixels = (byte[])iPlus.getProcessor().getPixels();
        int x=0;
        int y=0;
        int red = color.getRed();
        int blue = color.getBlue();
        int green = color.getGreen();
        for (int i = 0 ; i<lineagePixels.length;++i){
            int alpha = (int)lineagePixels[i];
            if (alpha < 0){
                alpha = alpha + 256;
            }

            try {
            Color pixelColor = new Color(red,green,blue,alpha);
            ret.setRGB(x, y, pixelColor.getRGB());
            } catch (Exception exc){
                int ouhiu=0;
            }
            
            ++x;
            if (x == w){
                x = 0;
                ++y;
                
            }
        }
        
        return ret;
    } 
    public void addLabel(String s,int x,int y){
        if (x != -1 && y != -1) {
            labels.add(new Label(s,x,y));
        }
    }
    public void clearLabels(){
        labels = new ArrayList<Label>();
    }
    
    public String getLineagingFile(){
        return this.lineageFile.getPath();
    }
    // for testing
    static public void main(String[] args){

        try {
        TIFF tif = new TIFF("/nfs/waterston1/images/murray/20070725_vab-7_6");
        tif.setTimeAndPlane(5,9);
        BufferedImage image = tif.getImage(true, false);
        int jashfd=0;            
//            TiffSeries ts = new TiffSeries("20070725_vab-7_6");
//            ts.getImage();
        } catch(Exception exc){
            exc.printStackTrace();
        }
    }
    public class Label {
        public Label(String s,int x,int y){
            this.text = s;
            this.x = x;
            this.y = y;
        }
        String text;
        int x;
        int y;
    }
    boolean status;
    int time;
    int plane;
    String prefix;
    File lineageFile;
    File expressFile;
    ArrayList<Label> labels;
}
