/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging;
import java.awt.Color;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.db.beans.IntergenicRegion;
import org.rhwlab.db.beans.ChromosomeRegion;
import java.awt.image.BufferedImage;
import java.awt.Graphics2D;
import java.awt.image.AffineTransformOp;
import java.awt.geom.AffineTransform;

/**
 *
 * @author gevirl
 */
public class IntergenicRegionImage {
    public IntergenicRegionImage(Gene gene,IntergenicRegion region){
        this.gene = gene;
        this.region = region;
        left.setColor(Color.blue);
        left.setRegion(new ChromosomeRegion(region.getChromosome(),region.getStart(),gene.getRegion().getStart()));
        if (region.getUpGene() != null) left.setLabel(region.getUpGene().getStrandLabel());
        left.setDisplayLabel(true);
        
        right.setColor(Color.blue);
        right.setRegion(new ChromosomeRegion(region.getChromosome(),gene.getRegion().getEnd(),region.getEnd()));
        if (region.getDownGene()!=null) right.setLabel(region.getDownGene().getStrandLabel());
        right.setDisplayLabel(true);
        
        middle = new GeneRegionImage(gene);
        middle.setColor(Color.green);
    }
    public BufferedImage  getImage(){       
        BufferedImage image = new BufferedImage(width,height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        
        g2.drawImage(left.getImage(),new AffineTransformOp(new AffineTransform(),AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,0);
        int pos = left.getWidth();
        g2.drawImage(middle.getImage(),new AffineTransformOp(new AffineTransform(),AffineTransformOp.TYPE_NEAREST_NEIGHBOR),pos,0);
        pos = pos + middle.getWidth();
        g2.drawImage(right.getImage(),new AffineTransformOp(new AffineTransform(),AffineTransformOp.TYPE_NEAREST_NEIGHBOR),pos,0);
                         
        return image;
    }
    public void setScale(int scale){
        left.setScale(scale);
        middle.setScale(scale);
        right.setScale(scale);
        this.scale = scale;
        this.width = left.getWidth()+middle.getWidth()+right.getWidth();
    }
    public void setHeight(int h){
        height = h;
        left.setHeight(h);
        middle.setHeight(h);
        right.setHeight(h);
    }
    public int getWidth(){
        return width;
    }
    // return the gene if x is located on the gene image
    public Gene getGene(int x){
        if (x > left.getWidth() && x< middle.getWidth()+left.getWidth()){
            return gene;
        }
        return null;
    }
    Gene gene;
    IntergenicRegion region;
    RegionImage left = new RegionImage();
    RegionImage right = new RegionImage();
    GeneRegionImage middle;    
    int height;
    int width;
    int scale;
}
