/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging;
import java.awt.Color;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.db.beans.IntergenicRegion;
import org.rhwlab.db.beans.ChipSeqBindingSite;
import org.rhwlab.db.beans.CombinedRegion;
import java.util.List;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.awt.Graphics2D;
import java.awt.image.AffineTransformOp;
import java.awt.geom.AffineTransform;
/**
 *
 * @author gevirl
 */
public class BindingSitesImage extends IntergenicRegionImage {
    public BindingSitesImage(Gene gene,IntergenicRegion region,List<CombinedRegion> sites){
        super(gene,region);
        this.sites = sites;
    }
    public BufferedImage getImage(){
        BufferedImage image = super.getImage();
        
        BufferedImage totalImage = new BufferedImage(image.getWidth(),image.getHeight()+20,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = totalImage.createGraphics();
        g2.drawImage(image, rop,0,0);
        
        // add all the binding sites
        for (CombinedRegion site : sites){
            RegionImage siteImage = new RegionImage();
            siteImage.setColor(Color.red);
            siteImage.setRegion(site.getRegion());
            siteImage.setHeight(image.getHeight());
            siteImage.setScale(scale);
            
            int pos = (site.getRegion().getStart() - region.getStart())/scale;
            g2.drawImage(siteImage.getImage(),rop,pos,0);
 //           g2.setColor(Color.black);
 //           g2.drawString(site.getLabel(), pos, image.getHeight());
        }
        return totalImage;
    }
    public CombinedRegion getSite(int ax){
        int x = scale*ax + region.getStart();
        for (CombinedRegion site : sites){
            if (x >= site.getStart() && x<= site.getEnd() ) {
                return site;
            }
                
        }
        return null;
    }
    List<CombinedRegion> sites;
    float[] scales = {1f,1f,1f,0.5f};
    float[] offsets = new float[4];
    RescaleOp rop = new RescaleOp(scales,offsets,null);
}
