/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.heatmap;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.tc33.jheatchart.HeatChart;

/**
 *
 * @author gevirl
 */
public class JHeatChartPanel extends JPanel {
    public JHeatChartPanel(double[][] z){
        this.z = z;
        heatChart = new HeatChart(z);
        heatChart.setShowXAxisValues(false);
        heatChart.setShowYAxisValues(false);
    }
    public void init(){
        heatChart.setLowValueColour(Color.blue);
        heatChart.setHighValueColour(Color.yellow); 
        double low = heatChart.getLowValue();
        double high = heatChart.getHighValue();
        
        if (xValues!=null) heatChart.setXValues(xValues);
        if (yValues !=null )heatChart.setYValues(yValues);
        
    }
  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2d = (Graphics2D) g;

    int width = this.getWidth();
    int height = this.getHeight();

    this.setOpaque(true);

    // clear the panel
    g2d.setColor(bg);
    g2d.fillRect(0, 0, width, height);
    
    BufferedImage imageTotal = (BufferedImage)heatChart.getChartImage();
    int bfHeight = imageTotal.getHeight();
    int bfWidth = imageTotal.getWidth();
    
    int delta = 100;
    BufferedImage labelImage = imageTotal.getSubimage(0, bfHeight-delta, bfWidth, delta);
   
//    AffineTransform xform = new AffineTransform();
//    xform.scale(1.0, .01);
//    g2d.drawImage(bufferedImage, xform, null);
    g2d.drawImage(imageTotal, 0, 0, width , height - delta, 0, 0,bfWidth,bfHeight-delta,null);
    g2d.drawImage(labelImage, 0, height - delta, width , height, 0, 0,bfWidth,delta,null);
    }

    public void setXValues(Object labels){
        xValues = (Object[])labels;
        heatChart.setShowXAxisValues(true);
    }
    public void setYValues(Object labels,int freq){
        yValues = (Object[])labels;
        heatChart.setShowYAxisValues(true);
        heatChart.setYAxisValuesFrequency(freq);
    }    
    private Color bg = Color.white;    
    double[][] z;
    Object[] xValues;
    Object[] yValues;
    HeatChart heatChart;
}
