/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.grid;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

/**
 *
 * @author gevirl
 */
public class GridSubmit {
    String runID;
    String program;
    File qsub;
    File runningDirectory;
    ArrayList<String> options;
    PrintWriter writer;  // for writing commands to the qsub file
    boolean local = false;
    int memory;
    int slots;
    
    public GridSubmit(String runID,String program,File dir){
        this.runID = runID;
        this.program = program;
        this.runningDirectory = dir;
        boolean b = this.runningDirectory.mkdirs();
        try {
            Process p = Runtime.getRuntime().exec(String.format("mkdir -p %s",this.runningDirectory.getPath()));
        } catch (Exception exc){
            exc.printStackTrace();
            return;
        }
        options = new ArrayList<>();
        
        qsub = qsubFile();
    }
    public void addOption(String option){
        options.add(option);
    }
    public void setMemory(int gigs){
        this.memory = gigs;
        addOption(String.format("-l mfree=%dG",gigs));
    }
    public void setRuntime(int hours){
        addOption(String.format("-l h_rt=%d:0:0",hours));
    }
    public void setQueue(String queue){
        if (queue.equals("sage")){
            addOption(String.format("-P %s",queue));
        } else if (queue.equals("local")){
            local = true;
        }
        
    }
    public void setSlots(int slots){
        this.slots = slots;
        if (slots > 1){
            addOption(String.format("-pe serial %d",slots));
            addOption(String.format("-binding linear_automatic:%d\n",slots));    
        }
    }
    public void setConcurrent(int con){
        addOption(String.format("-tc %d",con));
    }
    public void setArrayjob(String range){
        addOption(String.format("-t %s", range));
    }
    public void run()throws Exception {
        writer.close();
        if (local){
            ProcessBuilder pb = new ProcessBuilder(qsub.getPath());
            pb.redirectError(new File(qsub.getPath().replace("qsub","error")));
            pb.redirectError(new File(qsub.getPath().replace("qsub","out"))); 
            pb.start();
        }else {
            // create a script file for submitting the job on grid machine
            File scriptFile = scriptFile();
            PrintWriter scriptWriter = new PrintWriter(scriptFile);
            scriptWriter.println("#! /bin/bash"); 
            scriptWriter.printf("qsub -e %s -o %s %s > %s.out\n", runningDirectory.getPath(),runningDirectory.getPath(),qsub.getPath(),qsub.getPath());
            scriptWriter.close();
            scriptFile.setReadable(true,false);
            scriptFile.setExecutable(true, false);
            scriptFile.setWritable(true, false);    

            ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile.getPath());
            Process p = pb.start();      
        }
    }

    public File writeScriptFile()throws Exception {
            // create a script file for submitting the job on grid machine
            File scriptFile = scriptFile();
            PrintWriter scriptWriter = new PrintWriter(scriptFile);
            scriptWriter.println("#! /bin/bash"); 
            scriptWriter.printf("qsub -e %s -o %s %s > %s.out\n", runningDirectory.getPath(),runningDirectory.getPath(),qsub.getPath(),qsub.getPath());
            scriptWriter.close();
            scriptFile.setReadable(true,false);
            scriptFile.setExecutable(true, false);
            scriptFile.setWritable(true, false); 
            int asdfuih=0;
            return scriptFile;
    }
    // initializes the qsub file with the options and return a PrintWriter for adding commands to the qsub file
    public PrintWriter initializeQsub()throws Exception {
        qsub.createNewFile();
        
        writer = new PrintWriter(qsub);
        qsub.setReadable(true,false);
        qsub.setExecutable(true, false);
        qsub.setWritable(true, false);        
        
        writer.println("#$ -S /bin/bash");
        for (String option : options){
            writer.printf("#$ %s\n",option);
        }
        writer.printf("cd %s\n", runningDirectory.getPath());
        return writer;
    }
    // runs a java class main(String[] args) in the submission
    public void runJavaClass(String jarFile,String className,List<String> args){
//        writer.println("module load java/8u25");
        writer.printf("/nfs/waterston/jdk1.8.0_102/bin/java -Xms%dG -classpath %s %s ",memory*slots, jarFile,className);
        for (String arg : args){
            writer.printf("%s ", arg);
        }
        writer.println();
    }

    public File scriptFile(){
        return new File(runningDirectory,runID+"_"+program+".sh");
    }
    public final File qsubFile(){
        if (Character.isDigit(runID.charAt(0))){
            return new File(runningDirectory,"_"+runID+"_"+program+".qsub");
        }
        return new File(runningDirectory,runID+"_"+program+".qsub");
    }
    // extract the program name from the qsub file name
    static String program(String qsub){
        String trimmed = qsub.substring(0, qsub.indexOf(".qsub"));
        return trimmed.substring(trimmed.lastIndexOf("_")+1);
    }
    // return the latest error file for each program run on the grid in the directory
    public JsonObject latestErrorFiles(){
        
        TreeMap<String,File> ret = new TreeMap<>();
        File[] files = runningDirectory.listFiles();
        if (files != null){
            for (File file : runningDirectory.listFiles()){
                String name = file.getName();
                if (name.contains(".qsub.e")){
                    String program = program(name);
                    File latest = ret.get(program);
                    if (latest == null){
                        ret.put(program,file);
                    } else {
                        if (latest.lastModified()<file.lastModified()){
                            ret.put(program,file);
                        }
                    }
                }
            }
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (String program : ret.keySet()){
            builder.add(program,ret.get(program).getPath());
        }
        return builder.build();
    }

}
