/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.genemodel;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class AnnotationModel {
    // build the annotation model from gtf or gff
    public AnnotationModel(String idAttr,String parentAttr,String nameAttr)throws Exception {
        Annotation.id = idAttr;
        Annotation.parent = parentAttr;
        Annotation.name = nameAttr;
/*        
        BufferedReader reader = new BufferedReader(new FileReader(annotationFile));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
            
            Annotation annot;
            if (tokens[2].equals("exon")){
                annot = new Exon(tokens);
            } 
            else if (tokens[2].equals("mRNA")){
                annot = new mRNA(tokens);
            }      
            else if (tokens[2].equals("CDS")){
                annot = new CDS(tokens);
            }        
            else if (tokens[2].equals("gene")){
                annot = new Gene(tokens);
            }            
            else {
                annot = new Annotation(tokens);
            }
            
            String[] id = annot.getAttributeValue(idAttr);
            if (id != null){
                putInMap(id,annot,byIdMap);
                String[] key = new String[2];
                key[0] = annot.getType();
                key[1] = annot.getID();
                putInMap(key,annot,byTypeMap);
            }
            
            String[] parent = annot.getAttributeValue(parentAttr);
            if (parent != null){
                putInMap(parent,annot,byParentMap);
            }

            String[] name = annot.getAttributeValue(nameAttr);
            if (name != null){
                putInMap(name,annot,byNameMap);
            }   
            
            
            line = reader.readLine();
        }
        reader.close();
*/        
    }
    private void putInMap(String[] keys,Annotation annot,TreeMap<String,TreeMap<String,List<Annotation>>> map){
        TreeMap<String,List<Annotation>>typeMap = map.get(keys[0]);
        if (typeMap == null){
            typeMap = new TreeMap<>();
            map.put(keys[0],typeMap);
        }
        List<Annotation> annotList = typeMap.get(keys[1]);
        if (annotList == null){
            annotList = new ArrayList<>();
            typeMap.put(keys[1],annotList);
        }
        annotList.add(annot);
    }
    private List<Annotation> getFromMap(String key,TreeMap<String,TreeMap<String,List<Annotation>>> map){
        String[] keys = key.split(":");
        if (keys.length == 1){
            return map.firstEntry().getValue().get(key);
        } else {
            return map.get(keys[0]).get(keys[1]);
        }
    }

    // get all the annotations with the given parent prefix that include an annotation of content
    // return all with the prefix if content is null
    public TreeMap<String,List<Annotation>> getAnnotationsByParentPrefix(String prefix,String content){
        TreeMap<String,List<Annotation>> ret = new TreeMap<>();
        TreeMap<String,List<Annotation>> typeMap = byParentMap.get(prefix);
        for (Entry entry : typeMap.entrySet()){
            List<Annotation> annots = (List<Annotation>)entry.getValue();
            for (Annotation annot : annots){
                if (content==null || annot.type.equals(content)){
                    ret.put((String)entry.getKey(), annots);
                    break;
                }
            }
        }
        return ret;        
    }
    public TreeMap<String,List<Annotation>> getAnnotationsByParentPrefixWithoutContent(String type,String content){
        TreeMap<String,List<Annotation>> ret = new TreeMap<>();
        TreeMap<String,List<Annotation>> typeMap = byParentMap.get(type);
        for (Entry entry : typeMap.entrySet()){
            boolean toAdd=true;
            List<Annotation> annots = (List<Annotation>)entry.getValue();
            for (Annotation annot : annots){
                if (annot.type.equals(content)){
                    toAdd=false;
                    break;
                }
            }
            if (toAdd){
                ret.put((String)entry.getKey(), annots);
            }
        }
        return ret;        
    }    
    public TreeMap<String,List<Annotation>> getAnnotationsByParentPrefixes(String[] prefixes,String content){
        TreeMap<String,List<Annotation>> ret = new TreeMap<>();
        for (String prefix : prefixes){
            ret.putAll(getAnnotationsByParentPrefix(prefix,content));
        }
        return ret;
    }
    public TreeMap<String,List<Annotation>> getAnnotationsByParentType(String parentType){
        return null;
    }
    // filter the exons from a list of annotations and sort by position
    public List<Annotation> getExons(List<Annotation> list){
        ArrayList<Annotation> ret = new ArrayList<>();
        
        if (list.isEmpty()){
            return ret;
        }
        for (Annotation child : list){
            if (child instanceof Exon){
                ret.add((Exon)child);
            }
        }
        ret.sort(null);
        return ret;
    }

    // form list of sorted exons for each transcript given the attribute to use as transcript identifier
    public TreeMap<String,List<Annotation>> formTranscripts(String attrName){
        TreeMap<String,List<Annotation>> ret = new TreeMap<>();
        for (Annotation annot : typeMap.get("exon")){
            Object annotValue = annot.getAttributeValue(attrName);
            String value = (String)annotValue;
            List<Annotation> list = ret.get(value);
            if (list == null){
                list = new ArrayList<>();
                ret.put(value,list);
            }
            list.add(annot);
            
        }
        for (String transcript : ret.keySet()){
            List<Annotation> list = ret.get(transcript);
            list.sort(Annotation.comparer);
        }
        return ret;
    }
    public Object getAnnotations(String id){
        return idMap.get(id);
    }

    static String[] transcriptTypes = {"Transcript","CDS","Pseudogene"};
/*    
    static public void main(String[] args) throws Exception {
       AnnotationModel gff3 = new AnnotationModel("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3","ID","Parent","Name");
       int aiushdfuis=0;
 //      TreeMap<String,List<Annotation>> allTransripts = gff3.getAnnotationsByParentTypes(transcriptTypes,"exon");
 
        AnnotationModel model = new AnnotationModel("/net/waterston/vol9/References/Release6/dmel-all-r6.15.gtf","gene_id","transcript_id","transcript_symbol");
        TreeMap<String,List<Annotation>> allTransripts = model.getAnnotationsByParentPrefix("transcript_id","exon");
        TreeMap<String,List<Annotation>> noExons = model.getAnnotationsByParentPrefixWithoutContent("transcript_id","exon");
        int iusdfiushd=0;
        
    }
*/
    TreeSet<Gene> geneSet = new TreeSet<>(); // set of all the genes in the gff
    TreeMap<String,TreeMap<String,List<Annotation>>> byParentMap = new TreeMap<>(); // annotations by parent id
    TreeMap<String,Object> idMap = new TreeMap<>();  // annotations by the id - can be a list or a single annotation
 //   TreeMap<String,TreeMap<String,List<Annotation>>> byNameMap = new TreeMap<>(); // annotation by the name
//    TreeMap<String,TreeMap<String,List<Annotation>>>  byTypeMap = new TreeMap<>(); // annotation by the typeq
    TreeMap<String,List<Annotation>> typeMap = new TreeMap<>();  // annotations by the type
}
