/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.genemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
    abstract public class Annotation implements Comparable {
        static public String id;
        static public String parent;
        static public String name;
        
        public Annotation(String[] tokens){
            if (chromoRenameMap != null){
                this.chromo = chromoRenameMap.get(tokens[0]);
            } else {
                this.chromo = tokens[0];
            }
            source = tokens[1];
            this.type = tokens[2];
            this.start = Integer.valueOf(tokens[3]);
            this.end = Integer.valueOf(tokens[4]);
            this.strand = tokens[6];
            this.phase = tokens[7]; 
            addAttributes(tokens[8]);
        }

        Object getAttributeValue(String attr) {
            return attributes.get(attr);
        }
 /*       
        void addAttributes(String attrStr){
            String[] attrs = attrStr.split(";");
            for (String attr : attrs){
                
                String[] attrTokens;
                if (attr.contains("=")){
                    attrTokens = attr.trim().split("=");    
                } else {
                    attrTokens = attr.trim().split(" ");
                }
                
                attrTokens[1] = attrTokens[1].replaceAll("\"", "");   // remove any quotes from the attribute value
                
                if (!attrTokens[1].contains(",")){
                    attributes.put(attrTokens[0],attrTokens[1]);
                }else {
                    ArrayList<String> values = new ArrayList<>();
                    for (String value : attrTokens[1].split(",")){
                        values.add(value);
                    }
                    attributes.put(attrTokens[0],values);
                }                
            }            
        }
        */
        abstract void addAttributes(String attrStr);
        abstract public String getID();
        
        @Override
        public int compareTo(Object o) {
            return comparer.compare(this, o);
        }   
        
        // extract the sorted list of exons from a list of annotations
        static public List<Exon> getExons(List<Annotation> children){
            ArrayList<Exon> ret = new ArrayList<>();
            for (Annotation child : children){
                if (child instanceof Exon){
                    ret.add((Exon)child);
                }
            }
            ret.sort(comparer);
            return ret;
        } 
/*
        public String[] getAttributeValue(String attr){
            
            String attrString = attributes.get(attr);
            if (attrString == null) return null;
            
            String[] attrValues = attrString.split(",");
            ArrayList<String
            for (String attrValue : attrValues){
                
            }
            String[] ret = new String[2];
            if (value.contains(":")){
                ret = value.split(":");
            } else {
                ret[0] = attr;
                ret[1] = value;
            }
            return ret;
        }
        // may return null;
        public String getID(){
            String ret = attributes.get(id);
            return ret;
        }
        public String getName(){
            return getID().split(":")[1];
        }
        final public String[] getParent(){
            String parents = attributes.get(parent);
            if (parents == null){
                return new String[0];
            }
            return parents.split(",");
        }
        

        public String toString(){
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("%s\t%s\t%s\t%d\t%d\t.\t%s\t%s\t",this.chromo,this.source,this.type,this.start,this.end,this.strand,this.phase));
            boolean first = true;
            for (String key : this.attributes.keySet()){
                if (!first){
                    builder.append(";");
                }
                first = false;
                String value = this.attributes.get(key);
                builder.append(String.format("%s=%s",key,value));
            }
            
            return builder.toString();
        }

*/
        public String getChromosome(){
            return this.chromo;
        }
        public String getType(){
            return this.type;
        }     
        public int getLength(){
            return end-start+1;
        }
        public String getStrand(){
            return this.strand;
        }        
        String chromo;
        String source;
        String type;
        String phase;
        int start;
        int end;
        String strand;
        HashMap<String,Object> attributes=new HashMap<>();
        static AnnotationComparator comparer = new AnnotationComparator();
        public static TreeMap<String,String> chromoRenameMap;
        
//        List<Annotation> children= new ArrayList<>();


    }